--[[
***************************************************************
*** NOTICE TO WRITERS: ***
- Please use Canadian standard English.

***************************************************************
*** NOTICE TO TRANSLATORS: DO NOT EDIT THIS FILE DIRECTLY! ***

We have a standard PO file for translation in ../languages/strings.pot
To locally modify our translations:
- Extract data.zip as described in ../../scripts_readme.txt
- Edit ../../localizations/zh_cn.po
To add a new language:
- Use a PO editor such as POEdit (http://www.poedit.net/) to translate strings.pot
- Save your PO file as ../../localizations/lang.po and create ../content/localizations/lang.lua
- Add your lang.po to ../languages/loc.lua
***************************************************************


***************************************************************
-- For developers to keep the .pot file up to date
-- 1. Run ../../../updateprefabs.bat
***************************************************************
]]

STRINGS = {}
STRING_METADATA = {} -- Don't reference from non-localization code!

-- Do not add quest strings here!!!!
require "strings.strings_cosmetics"
require "strings.strings_items"
require "strings.strings_names"
require "strings.strings_player_attacks"
require "strings.strings_slideshow"
require "strings.strings_weapontips"
require "strings.strings_credits"
if not POT_GENERATION then
	-- Skip for .pot generation since it's already translated.
	require "strings.strings_pretranslated"
end

STRINGS.GAME = {
	-- Should match AppVersion::GetAppFriendlyName()
	NAME = "Rotwood",
}


STRINGS.CRASHREPORTER = {
	-- Translations must be manually applied to tools/CrashReporterWindows/source/CrashReporterWindows.rc
	IDS_APP_TITLE = "Rotwood Crash Reporter",
	IDS_DLG_TITLE = "It appears Rotwood has crashed.\nPlease visit our support page for fixes to common problems: <a>http://klei.gg/rotwoodhelp</a>",
	IDS_DLG_INSTRUCTIONS = "Can you describe what was going on in the game when the crash happened?",
	IDS_DLG_FILES = "Files to include:",
	IDS_FORCE_SEND = "Force send of crash report.",
	IDS_FAILED_TO_SEND = "Crash report failed to sendout",
	IDS_SEND = "Send",
	IDS_ERROR = "Error",
	IDS_CANCEL = "Cancel",
	IDS_SEND_SUCCESS = "Crash report sent. Thank you!",
	IDS_SUCCESS = "Success",
}

STRINGS.FEEDBACK = {
	VERY_BAD = "Very Bad",
	BAD = "Bad",
	NEUTRAL = "Neutral",
	GOOD = "Good",
	VERY_GOOD = "Very Good",
}

STRINGS.ITEM_CATEGORIES =
{
	WEAPON = "Weapon",

	HAMMER = "{name.weapon_hammer}",
	CLEAVER = "{name.weapon_greatsword}",
	POLEARM = "{name.weapon_polearm}",
	CANNON = "{name.weapon_cannon}",
	SHOTPUT = "{name.weapon_shotput}",

	BODY = "Body",
	HEAD = "Helmet",
	SHOULDERS = "Shoulder",
	WAIST = "Legs", --somewhat temp, this slot contains everything lower body the same way "Body" contains everything mid-body
	ARMS = "Hand",
	LEGS = "Foot",

	HEART = "{name.boss_heart}",

	POTIONS = "{name_multiple.potion}",
	TONICS = "{name_multiple.tonic}",
	MATERIALS = "{name_multiple.material}",
	FOOD = "Lunch Box",
	KEY_ITEMS = "Key Items",

	-- Collects of Slots
	ARMOUR_SETS = "Armour Sets",
	BUFFING_ITEMS = "Consumables",

	MONSTER_MATERIALS = "Mohg Drops",
	BIOME_MATERIALS = "Regional Drops",
	GLOBAL_MATERIALS = "Global Drops",
	CURRENCY_MATERIALS = "Currencies",

	-- Powers
	CHEAT = "Dirty Cheaters",
	PLAYER = "Old Magics",
	ELECTRIC = "Electric",
	SUMMON = "Summon",
	SEED = "Seed",
	SHIELD = "Sustain",
	TONIC = "{name.tonic}",
	STATUSEFFECT = "Status Effects",
	SKILL = "{name.concept_skill}",
	FOOD_POWER = "Food",
	POTION_POWER = "{name.potion}",
	MOVEMENT = "Movement",
	EQUIPMENT = "Equipment",
	GEMS = "{name_multiple.gem}",

	FAVOURITES = "Favourites",
	BUILDINGS = "Buildings",
	STRUCTURES = "Structures",
	DECOR = "Decor",
	TOWN = "Town",

	GROAK = "Groak",

	-- Meta Progress

	BIOME_EXPLORATION = "Biome Exploration",
	MONSTER_RESEARCH = "Monster Research",
	KONJUR_CONVERSION = "Teffra Conversion",
	WEAPON_UNLOCKS = "Weapon Unlocks",

	RELATIONSHIP_CORE = "Core Relationships",

	DEFAULT_UNLOCK = "Default Unlocks",

	-- Masteries
	WEAPON_MASTERY = "Weapon Mastery",
	MONSTER_MASTERY = "Monster Mastery",
}

STRINGS.WEAPONS =
{
	UNLOCK =
	{
		TITLE = "New Weapon Unlocked!",
		HAMMER = "You unlocked the {name.weapon_hammer}!",
		POLEARM = "You unlocked the {name.weapon_polearm}!",
		SHOTPUT = "You unlocked the {name.weapon_shotput}!",
		CANNON = "You unlocked the {name.weapon_cannon}!",
	},
	HOW_TO_PLAY =
	{
		HAMMER = "Specializes in close combat encounters and fighting large groups of enemies.",
		POLEARM = "Specializes in high single-target <#RED>{name.concept_damage}</> and keeping the enemy at bay.",
		CANNON = "A long-range weapon that can deal <#RED>{name.concept_damage}</> at a distance, but is vulnerable when the clip is empty.\nUse the shotgun blast to <#RED>{name.concept_dodge}</>!",
		SHOTPUT = "A mid-range weapon that mixes ranged and melee attacks.",
	},
	FOCUS_HIT =
	{
		HAMMER = "<#BLUE>{name.concept_focus_hit}:</BLUE>\n• Hit multiple enemies with one swing\n• Fully charge a <#RED>Heavy Attack</RED> combo ender\n• Fully charge a <#RED>Golf Swing</>",
		POLEARM = "<#BLUE>{name.concept_focus_hit}:</BLUE>\n• Hit an enemy with the tip of your <#RED>{name.weapon_polearm}</>\n• Hit multiple enemies with the <#RED>Spinning Drill</>",
		SHOTPUT = "<#BLUE>{name.concept_focus_hit}:</BLUE>\n• Hit an airborne <#RED>{name.weapon_shotput}</>\n• Throw a <#RED>{name.weapon_shotput}</> immediately after catching it",
		CANNON = "<#BLUE>{name.concept_focus_hit}:</BLUE>\n• Last three shots of your clip",
	}
}

STRINGS.POWERS = {
	POWER_TYPE = {
		RELIC = "{name.concept_relic}",
		FABLED_RELIC = "Fabled {name.concept_relic}",
		SKILL = "{name.concept_skill}",
		MOVEMENT = "Movement",
		FOOD = "Food",
		EQUIPMENT = "Equipment",
		HEART = "{name.boss_heart}",
	},
	POWER_CATEGORY = {
		ALL = "All",
		SUPPORT = "Summon", --HACK: grab the actual power family when we add more/when we add family-specific drops
		DAMAGE = "Electric", --HACK: grab the actual power family when we add more/when we add family-specific drops
		SUSTAIN = "Shield", --HACK: grab the actual power family when we add more/when we add family-specific drops
	},
	POWER_RARITY = {
		COMMON = "Common",
		EPIC = "Epic",
		LEGENDARY = "Legendary",
	},
}

STRINGS.GEMS = {
	SLOT_TYPE = {
		DAMAGE = "{name.concept_damage}",
		SUPPORT = "Support",
		SUSTAIN = "Sustain",
		ANY = "Any",
	}
}

STRINGS.CHARACTER_SELECTOR =
{
	TITLE_SELECT = "Select Character Slot",
	START_BUTTON = "<p bind='Controls.Digital.MENU_SCREEN_ADVANCE' color=0> START!",
	NEW_CHARACTER = "Make New Character",
	SLOT = "Slot {slot_number}",
	SLOT_IN_USE = "Slot {slot_number} (In Use)",
	SLOT_YOUR_SLOT = "Slot {slot_number} (Current Selection)",
	INFO_LABEL = "<p bind='Controls.Digital.ATTACK_HEAVY' color=0> Remove a character",
	DELETE_TITLE = "Delete Character",
	DELETE_SUBTITLE = "Cannot be undone!",
	DELETE = "Do you really want to delete Slot {slot_number}?",
	DELETE_CONFIRM = "Delete",
	DELETE_CANCEL = "Cancel",
}

STRINGS.CHARACTER_CREATOR =
{
	TITLE_SELECT = "<b>Select a Hunter!</b>\nSpecies selection will not affect Hunter stats.",
	REROLL_BUTTON = "<p img='images/ui_ftf_character/BtnReroll.tex' color=0 scale=2.5>\n\nREROLL",
	REROLL_BUTTON_TOOLTIP = "Randomize your look!",
	SHOWING_ARMOR_BUTTON = "<p img='images/ui_ftf_character/BtnShowingArmor.tex' color=0 scale=2.5>\n\nSHOWING\nARMOUR",
	HIDE_ARMOR_BUTTON_TOOLTIP = "Click to toggle armour off",
	SHOW_ARMOR_BUTTON_TOOLTIP = "Click to toggle armour on",
	HIDING_ARMOR_BUTTON = "<p img='images/ui_ftf_character/BtnHidingArmor.tex' color=0 scale=2.5>\n\nHIDING\nARMOUR",
	CUSTOMIZE_BUTTON = "<p img='images/ui_ftf_character/BtnCustomize.tex' color=0 scale=0.9> CUSTOMIZE",
	CONTINUE_BUTTON = "SAVE CHANGES",
	REVERT_BUTTON = "<p img='images/ui_ftf_character/BtnRevert.tex' color=0 scale=2.5>\n\nREVERT ALL",
	REVERT_BUTTON_TOOLTIP = "Return to the default appearance of your chosen species",
	START_BUTTON = "<p bind='Controls.Digital.MENU_SCREEN_ADVANCE' color=0> START!",
	CHARACTER_DESC = "<p img='images/ui_ftf_character/QuotesLeft.tex' color=0 scale=0.9>{species_desc}<p img='images/ui_ftf_character/QuotesRight.tex' color=0 scale=0.9>",

	TAB_TITLE = "<p img='images/icons_ftf/character_title.tex' color=0 scale=0.9> TITLE",
	TAB_SPECIES = "<p img='images/icons_ftf/character_species.tex' color=0 scale=0.9> SPECIES",
	TAB_HEAD = "<p img='images/icons_ftf/character_head.tex' color=0 scale=0.9> HEAD",
	TAB_BODY = "<p img='images/icons_ftf/character_body.tex' color=0 scale=0.9> BODY",
	TAB_ARMORDYE = "<p img='images/icons_ftf/inventory_dye.tex' color=0 scale=0.9> ARMOR DYE",

	LOCKED_TOOLTIP = "Not available in this demo",--"Complete quests in the full game to unlock this!",
	CLICK_TOOLTIP = "Click to equip",

	LOCKED_DYE_TOOLTIP = "Visit the market during a run to discover new dyes!",

	NO_CHANGES = "No changes to revert!",

	UNSAVED_POPUP_TITLE = "UNSAVED CHANGES!",
	UNSAVED_POPUP_DESC = "You will lose all your customization changes, do you wish to continue?",
	UNSAVED_POPUP_YES = "Yes",
	UNSAVED_POPUP_NO = "Cancel",

	SWITCH_SPECIES_POPUP_TITLE = "CHANGE HUNTER SPECIES?",
	SWITCH_SPECIES_POPUP_DESC = "You'll need<p img='images/ui_ftf_icons/lesser_soul.tex'>%d to transform again if you change your mind.",
	BUY_SPECIES_TT = "Transform <p img='images/ui_ftf_icons/lesser_soul.tex'>%d",
	NOT_ENOUGH_TT = "Not enough<p img='images/ui_ftf_icons/lesser_soul.tex'>"
}

STRINGS.BODY_PARTS =
{
	HEAD = "Species", -- internally it's a head, but also determines other allowed parts
	HAIR = "Hair",
	HAIR_FRONT = "Bangs",
	HAIR_BACK = "Ponytail",
	BROW = "Brows",
	EYES = "Eyes",
	MOUTH = "Mouth",
	NOSE = "Nose",
	EARS = "Ears",
	ORNAMENT = "Adornment",
	SHIRT = "Torso",
	UNDIES = "Pelvis",
	ARMS = "Arms",
	LEGS = "Legs",
	OTHER = "Other",
}

-- The names of the different species
STRINGS.SPECIES_NAME =
{
	canine = "{name_multiple.species_canine}",
	mer = "{name_multiple.species_mer}",
	ogre =  "{name_multiple.species_ogre}",
}

STRINGS.SPECIES_DESCRIPTIONS =
{
	canine = "An invitation to pet a {name.species_canine}'s belly is always a trap.",
	mer = "The anemone of my anemone is my friend.",
	ogre = "A bit rough around the edges. And the middle.",
}

STRINGS.NPC_DIALOG =
{
	CONVO_BACK = "Back",
	CONVO_EXIT = "Bye!",

	KEYWORD_TIME_REMAINING = "Time in camp",
	KEYWORD_TIME_REMAINING_DESCRIPTION = "The camp occasionally gets colourful visitors. Some will only stay a short time before continuing on their way.",

	NPC_CRAFT_WEAPON_CHAT = "Here are the weapons I can forge if you bring me the right materials.",

	NPC_OPT_CRAFT_WEAPON = "You forge weapons?",
	NPC_OPT_BACK = "Back",
	NPC_OPT_LEAVE = "That's it. Bye!",

	NPC_CRAFT_COLUMN_ICON = "ITEMS",
	NPC_CRAFT_COLUMN_COST = "COST",
	NPC_CRAFT_COLUMN_EQUIPPED = "Equipped",
	NPC_CRAFT_COLUMN_EMPTY = "No item equipped",
	NPC_CRAFT_CRAFTED = "Added to your inventory!",
	NPC_CRAFT_KONJUR_SOUL_LESSER_COST = "<p img='images/ui_ftf_icons/lesser_soul.tex'> %d",
	NPC_CRAFT_KONJUR_SOUL_GREATER_COST = "<p img='images/ui_ftf_icons/greater_soul.tex'> %d",
	NPC_CRAFT_KONJUR_HEART_COST = "<p img='images/ui_ftf_icons/konjur_heart.tex'> %d",
	NPC_CRAFT_STAT = "%s",
	NPC_CRAFT_STAT_HIGHER = "%s<p img='images/ui_ftf_dialog/dialog_forge_cost_arrow.tex'>",

	NPC_CRAFT_DIALOG_ACCEPT = "<p bind='Controls.Digital.MENU_SCREEN_ADVANCE' color=0> Forge Item",
	NPC_CRAFT_DIALOG_CANCEL = "Cancel",
	NPC_CRAFT_DIALOG_EQUIP = "EQUIP AFTER FORGED",
	ALREADY_OWNED = "Item already owned!",
	RESOURCES_MISSING = "Resources missing!",
}

STRINGS.TALK = {
	-- Use these generic strings like this:
	--   cx:Talk("STRINGS.TALK.TALK_UNIMPORTANT")
	OPT_ACCEPT = "Accept",
	OPT_DECLINE = "Decline",
	OPT_BACK = "Back",
	OPT_LEAVE = "Sorry, I've gotta run!",
	OPT_OKAY = "Okay",
	OPT_NO_THANKS = "No thanks",
	TALK_UNIMPORTANT = "...",
	TITLE_TEMPWRITING = "TEMP WRITING",
	TITLE_PENDING_TRANSLATION = "Pending Translation",
}

STRINGS.TIME = {
	RUN_DURATION = {
		IN_HOURS = "{hours} HR {minutes} MIN {seconds} SEC",
		IN_MINUTES = "{minutes} MIN {seconds} SEC",
	},
}

STRINGS.JOB_DESCRIPTIONS =
{
	Scout = "Gathers and provides data about the current location of various {name_multiple.rot}.",
	ForgeWeapon = "Forges weapons out of various materials.",
	ForgeArmor = "Forges protective armour for use in combat.",
	BrewElixir = "Concocts interesting elixirs out of herbs and magical substances.",
	MixPotion = "Combines elixirs into useful potions.",
}

STRINGS.ASCENSIONS =
{
	-- Use STRINGS.NAMES.ascension for NAME.
	LEVEL_SIMPLE = "<p img='images/icons_ftf/ic_frenzy.tex' color=0 scale=0.8> FRENZY LEVEL {level_number}",
	NO_LEVEL_SIMPLE = "NO FRENZY ENABLED",
	LEVEL_TOOLTIP = "This Does Something!",
	LEVEL_LIMIT_INFO = "<p img='images/map_ftf/lock_icon.tex' color=0> LEVEL LIMIT: <#BACKGROUND_LIGHT>{limiting_player}</>'s Highest Frenzy Level ({highest_level})",
	LEVEL_LIMIT_INFO_SELF = "<p img='images/map_ftf/lock_icon.tex' color=0> LEVEL LIMIT: <#BACKGROUND_LIGHT>Your</> Highest Frenzy Level ({highest_level})",
	NO_LEVEL_INFO = "None",

	WEAPON_BUTTON = "<p bind='Controls.Digital.Y' color=0> Switch\nWeapon",
	MOBS_TITLE = "Native Rots",

	NORMAL = "",
	AGGRESSIVE_ENEMIES = "<p img='images/map_ftf/frenzy_3.tex' color=0> Enemies are more aggressive",
	AGGRESSIVE_ELITES = "<p img='images/map_ftf/frenzy_8.tex' color=0> Elites are more aggressive",
	AGGRESSIVE_BOSSES = "<p img='images/map_ftf/frenzy_9.tex' color=0> {name_multiple.rot_boss} are more aggressive",
	ENEMY_HEALTH_BOOST = "<p img='images/map_ftf/frenzy_4.tex' color=0> Enemies have more health",
	MORE_ENEMIES = "<p img='images/map_ftf/frenzy_5.tex' color=0> More enemies spawn",
	BOSS_HEALTH_BOOST = "<p img='images/map_ftf/frenzy_6.tex' color=0> {name_multiple.rot_boss} have more health",
	ADD_ELITES = "<p img='images/map_ftf/frenzy_2.tex' color=0> Elite enemies spawn",
	MORE_ELITES = "<p img='images/map_ftf/frenzy_7.tex' color=0> More elite enemies spawn",
	ELITE_MINIBOSS = "{name.rot_miniboss} is elite",
	STRONGER_TRAPS = "Traps deal more {name.concept_damage} to players",

	ASCENSION_ONE = "<p img='images/map_ftf/frenzy_2.tex' color=0> [TODO: remove number from icon] Elite basic enemies spawn\n[ICON] Reviving allies costs Health\n[ICON] Miniboss equipment available in market",
	ASCENSION_TWO = "<p img='images/map_ftf/frenzy_2.tex' color=0> [TODO: remove number from icon] Elite minor enemies spawn\n[TODO: Add big ticket item]",
	ASCENSION_THREE = "<p img='images/map_ftf/frenzy_2.tex' color=0>[TODO: remove number from icon] Minibosses spawn in normal encounters\n[TODO: Add big ticket item]",

	LEVEL_AVAILABLE = "{name.i_konjur_heart} Available!",
	LEVEL_COMPLETED = "<p img='images/ui_ftf_icons/completed.tex' color=0> Completed!",

	NONE = "No active modifiers.",

	-- Modifier descriptions with icons
    STRONG_ENEMIES_1 = "<p img='images/map_ftf/frenzy_strong_enemies_1.tex' color=0 scale=1.4> All {name_multiple.rot} are stronger",
    STRONG_ENEMIES_2 = "<p img='images/map_ftf/frenzy_strong_enemies_2.tex' color=0 scale=1.4> All {name_multiple.rot} are stronger",
    STRONG_ENEMIES_3 = "<p img='images/map_ftf/frenzy_strong_enemies_3.tex' color=0 scale=1.4> All {name_multiple.rot} are stronger",
    AGGRESSIVE_ENEMIES_1 = "<p img='images/map_ftf/frenzy_aggressive_enemies_1.tex' color=0 scale=1.4> All {name_multiple.rot} are more aggressive",
    AGGRESSIVE_ENEMIES_2 = "<p img='images/map_ftf/frenzy_aggressive_enemies_2.tex' color=0 scale=1.4> All {name_multiple.rot} are more aggressive",
    MORE_LOOT_1 = "<p img='images/map_ftf/frenzy_more_loot_1.tex' color=0 scale=1.4> More loot drops",
    MORE_LOOT_2 = "<p img='images/map_ftf/frenzy_more_loot_2.tex' color=0 scale=1.4> More loot drops",
    MORE_LOOT_3 = "<p img='images/map_ftf/frenzy_more_loot_3.tex' color=0 scale=1.4> More loot drops",
    ELITE_SPAWN_1 = "<p img='images/map_ftf/frenzy_elite_spawn_1.tex' color=0 scale=1.4> {name.elite_prefix} {name_multiple.rot} spawn",
    ELITE_SPAWN_2 = "<p img='images/map_ftf/frenzy_elite_spawn_2.tex' color=0 scale=1.4> Large {name.elite_prefix} {name_multiple.rot} spawn",
    MINIBOSS_SPAWN_1 = "<p img='images/map_ftf/frenzy_miniboss_spawn_1.tex' color=0 scale=1.4> {name_multiple.rot_miniboss} spawn in encounters",
    MINIBOSS_EQUIPMENT_1 = "<p img='images/map_ftf/frenzy_miniboss_equipment_1.tex' color=0 scale=1.4> Miniboss equipment in market",
    REVIVE_COST_1 = "<p img='images/map_ftf/frenzy_revive_cost_1.tex' color=0 scale=1.4> Reviving costs health",
    INGOTS_DROP_1 = "<p img='images/map_ftf/frenzy_ingots_drop.tex' color=0 scale=1.4> Fortifying ingots drop",
}

STRINGS.TOWN =
{
	HUD = {
		DAYS_OF_WEEK =
		{
			"Munnsday", --monday
			"Chuseday", --tuesday
			"Wendday", --wednesday
			"Thirsday", --thursday
			"Freeday", --friday
			"Sattaday", --saturday
			"Soonday", --sunday
		},
		KONJUR_TT = "<b>%s</>\n%s", -- How to format the tooltip.
	}
}

STRINGS.CRAFT_WIDGET =
{
	HUD_HOTKEY = "BUILD",
	LOCKED = "<#PENALTY>LOCKED</>",
	NEW = "New decor available!",
	SEARCH_PLACEHOLDER = "Search...",
	ITEM_UNSEEN_BADGE_TT = "New item!",
	CRAFT_BUTTON_UNSEEN_BADGE_TT = "There are new craftable items",

	CRAFT_PLACE = "Craft & Place",
	CRAFT_STORE = "<p bind='Controls.Digital.CLICK_SECONDARY' color=WHITE scale=1.3> Craft Item",
	PLACE = "<p bind='Controls.Digital.CLICK_PRIMARY' color=WHITE scale=1.3> Place Item",
	CANCEL = "Cancel",

	NO_PERMISSION = "<#PENALTY> You need permission to build in this town!</>",

	INGREDIENTS = "Ingredients",

	FOUND_IN = "Found in %s",

	FOUND_IN_FRENZY = "This material is only found in Frenzy Levels",

	CUSTOMIZE_BUILDING = "Customize Building",

	FIRST_TIME_CRAFT_REWARD_TITLE = "First Craft Bounty!",
	NEW_CRAFT_DESC = "You have never made this before",
}

STRINGS.UI =
{
	BULLET_POINT = "<p img='images/ui_ftf/point.tex' color=0 scale=0.3>",
	BULLET_DASH = "<p img='images/ui_ftf/dash.tex' color=0 scale=0.4>",
	KEYBOARD = "Keyboard",
	MAINSCREEN =
	{
		TITLE_GAMEFAIL = "Error in the Woods",
		TITLE_MODFAIL = "Mods are Wreaking Havoc",
		ISSUE = "Report an Issue",
		GETHELP = "Get More Help",

		INCOMPATIBLE_SAVE = {
			ASK_ERASE = {
				TITLE = "Save Data Not Compatible",
				BODY = "Thank you for playing!\nUnfortunately, your old data is no longer compatible.",
				CONFIRM = "Erase Save Data",
			},
			ERASE_COMPLETE = {
				TITLE = "Old Save Data Wiped",
				BODY = "Your old save files have been erased.",
			},
		},

		SCRIPTERRORSUBTITLE = "An error occurred that the game can't recover from.",
		SCRIPTERRORBACK = "<p img='images/ui_ftf/arrow_left.tex' scale=0.9 color=0>  Back",
		SCRIPTERRORMORE = "More Options  <p img='images/ui_ftf/arrow_right.tex' scale=0.9 color=0>",
		SCRIPTERRORQUIT = "<p img='images/ui_ftf_icons/exit.tex' scale=1.2 color=0>  Exit Game",
		SCRIPTERROR_COPY_CLIPBOARD = "<p img='images/ui_ftf_icons/clipboard.tex' scale=1.2 color=0>  Copy Error",
		SCRIPTERROR_RESTART = "<p img='images/ui_ftf_icons/restart.tex' scale=1.2 color=0>  Restart Level",
		SCRIPTERROR_WIPE = "<p img='images/ui_ftf_icons/delete.tex' scale=1.2 color=0>  Delete All Saves",
		SCRIPTERROR_DEBUG = "<p img='images/ui_ftf_icons/console.tex' scale=1.2 color=0>  Debug Console",
		SCRIPTERROR_BUGTRACKER = "<p img='images/ui_ftf_icons/bug.tex' scale=1.2 color=0>  Bug Tracker",
		SCRIPTERROR_SAVE_REPLAY = "Save Replay",
		SCRIPTERROR_MODWARNING = "You had these mods:\n",
		SCRIPTERROR_WIPESAVE =
		{
			TITLE = "Warning!",
			BODY = "Deleting save data will erase all gameplay progress for all characters",
			CONFIRM = "I am sure",
			CANCEL = "Maybe not...",
		},

		PLAY = "Press Any Button",
		ASKQUIT = "Quit Game?",
		ASKQUITSUBTITLE = "Are you sure you want to quit?",
		ASKQUITDESC = "{name.npc_scout} will miss you.",
		QUIT = "<p img='images/ui_ftf_icons/quit.tex' color=0 scale=1> Quit",
		YES = "Yes",
		NO = "No",
		BACK = "<p img='images/ui_ftf_dialog/ic_back.tex' color=0 scale=1.1> Back",
		MULTIPLAYER_INFO = "Character progress is saved and transferred across game types.",
		OFFLINE_ERROR = "<p img='images/icons_ftf/ic_offline.tex' color=0 scale=1.3> You're offline.",
		ONLINE_INFO = "Additional local players can be added in-game.",
		WISHLIST_CTA = "<p img='images/ui_ftf_icons/steam.tex' color=0 scale=1.3> Add to Wishlist",

		MODIFIED_DATA = "*** Warning - modifications to the game data were detected. The game may not behave correctly. ***",
		PROFILE_SECONDS = "Profiling game (%d)",
		PROFILE_PROCESSING = "Profiling game - processing data",
		TRANSLATION_WIP = "This translation is a work-in-progress. It is incomplete and does not represent the final game's translation quality.",

		BTN_SINGLE_PLAYER_TITLE = "Local Play",
		BTN_SINGLE_PLAYER_TEXT = "Set out on your own and explore the Rotwood at your own pace.",
		BTN_MULTI_PLAYER_TITLE = "Online Play",
		BTN_MULTI_PLAYER_TEXT = "Team up with local and online friends and face the Rotwood together.",
		BTN_MULTI_PLAYER_TEXT_OFFLINE = "Team up with local and online friends and face the Rotwood together.\n<#D6FEFF><p img='images/icons_ftf/ic_offline.tex' color=0 scale=1.3> No online connection available</>",
		BTN_JOIN_TITLE = "Join a Game",
		BTN_JOIN_TEXT = "Join a friend's online game using their ShareCode.",
		BTN_HOST_TITLE = "Host a Game",
		BTN_HOST_TEXT = "Host a game and send invites with your ShareCode.",

		JOIN_DIALOG_TITLE = "Join Online Game",
		JOIN_DIALOG_TEXT = "Enter your friend's ShareCode to join their game.",
		JOIN_DIALOG_BTN = "Go!",

		HOST_DIALOG_TITLE = "Host New Game",
		HOST_DIALOG_TEXT_FRIENDSONLY = "Start a friends-only game.",
		HOST_DIALOG_TEXT = "Press start to host your game online.",
		HOST_DIALOG_SUBTEXT = "<#LIGHT_TEXT_DARKER><p img='images/ui_ftf_icons/sharecode.tex' color=0 scale=1.2>  You'll get a ShareCode to invite others.</>",
		HOST_DIALOG_COPIED = "Copied to Clipboard",
		HOST_DIALOG_FRIENDS_CHECKBOX = "Only Steam Friends may join",
		HOST_DIALOG_BTN = "Start Game",
		HOST_DIALOG_USERGROUP_JOIN = "Share with Steam Groups",
		HOST_DIALOG_USERGROUP_JOIN_TOOLTIP = "When checked, players in that Steam Group can see and join your game.",
		HOST_DIALOG_LOADING_TEXT = "<p img='images/ui_ftf_icons/loading.tex' color=0 scale=0.8> Starting",

		HOST_DIALOG_SHARING_TITLE = "Confirm Group Sharing",
		HOST_DIALOG_SHARING_START = "Let's go!",
		HOST_DIALOG_SHARING_MORE = "And more...",
		HOST_DIALOG_SHARING_DESC = "Almost there! People in these groups will be able to join your game.\n\n<#DARK_TEXT_DARKER>%s</>\n\nAre you ready to Hunt?",

		HOST_DIALOG_DISCORD = "Join from Discord",
		HOST_DIALOG_DISCORD_OFF = "Off",
		HOST_DIALOG_DISCORD_OFF_TOOLTIP = "Do not allow joining from Discord.",
		HOST_DIALOG_DISCORD_PRIVATE = "Ask",
		HOST_DIALOG_DISCORD_PRIVATE_TOOLTIP = "Others have to ask to join.",
		HOST_DIALOG_DISCORD_PUBLIC = "Open",
		HOST_DIALOG_DISCORD_PUBLIC_TOOLTIP = "Others can join anytime.",

		DISCORD_CTA =
		{
			TITLE = "Join our Discord!",
			BODY = "Looking for people to play with?\nJoin our Discord!",
		},

		NOTICE_TITLE = "Notice!",
		NOTICE_DESC = "We changed the way Armor and Attack numbers are shown to be easier to read and compare different equipment.\n\nIt may look like your equipment has lower stats, but rest assured, your equipment remains the same, we have only changed how it's displayed.",
	},

	DAMAGE_NUMBERS =
	{
		CRIT = "<z 0.85>%s</>!", -- make the text a bit smaller, because we want the ! to be perceptibly bigger and cant set it to z >1. font size is increased in the widget to account for this.
		HEAL = "<z 0.9>+</z>%s",
	},

	ADDPLAYERDIALOG = {
		TITLE = "Add a local player",
		SUBTITLE = "Press any key on the gamepad you'd like to use.",
		CONFIRM_HINT = "<p bind='Controls.Digital.MENU_ACCEPT' color=0> Confirm",
		CANCEL_HINT = "<p bind='Controls.Digital.CANCEL' color=0> Cancel",
	},

	STEAMFRIENDSWIDGET =
	{
		TITLE = "Online Steam Friends",
		EMPTY_LABEL = "No friends currently playing Rotwood",
		JOIN_FRIEND_BTN = "Join",
		FRIEND_NOT_IN_LOBBY = "Not joinable",
	},
	
	STEAMUSERGROUPSWIDGET =
	{
		TITLE = "Steam Group Games",
		EMPTY_LABEL = "Nobody in your Steam Groups is currently playing Rotwood",
		JOIN_USERGROUP_BTN = "Quick Join",
		USERGROUP_NOT_IN_LOBBY = "Not joinable",
		NO_GAMES_TO_JOIN = "No games to join",
		ONE_GAME_TO_JOIN = "1 game to join",
		NR_GAMES_TO_JOIN = "%d games to join",
		MORE_NR_GAMES_TO_JOIN = "%d+ games to join",
		JOIN_RANDOM = "Join a random game",
		TT_GROUPS_ROW = " <p img='images/ui_ftf/point.tex' color=0 scale=0.3>  %s",
		TT_GROUPS_LIST = "Groups allowed in game:\n<#DARK_TEXT>%s</DARK_TEXT>"
	},

	HUNTPROGRESSWIDGET =
	{
		FALLBACK_FLITT_QUIP = "Heading home!",
	},

	PLAYERSSCREEN =
	{
		TAB_PLAYERS = "PLAYERS",
		TAB_BANNED = "BAN LIST",
		COPYCODE_BUTTON = "<p img='images/ui_ftf_online/button_copy_code.tex' color=0 scale=2.5>\n\nCOPY\nSHARECODE",
		ADDLOCALPLAYER_BUTTON = "<p img='images/ui_ftf_online/button_add_player.tex' color=0 scale=2.5>\n\nADD LOCAL\nPLAYER",
		SHARECODE_LABEL = "<p img='images/ui_ftf_icons/sharecode.tex' color=0 scale=1.2>  Send this ShareCode to invite other players.",

		ALLOW_TOWN_EDITING = "Allow Town Editing",
		TT_ALLOW_TOWN_EDITING = "Allow this client to add and remove decorations in town",

		PLAYER_HOST = "Host",
		PLAYER_AVAILABLE = "Available Player Slot",
		PLAYER_LOADING = "Loading",
		PLAYER_LOADING_DESC = "Picking a character",
		PLAYER_NO_DEVICE = "Disconnected!",

		BAN_BTN = "<p img='images/ui_ftf_online/ic_ban_player.tex' color=0 scale=2.5>\n\nBan\nPlayer",
		REMOVE_BTN = "<p img='images/ui_ftf_online/ic_remove_player.tex' color=0 scale=2.5>\n\nRemove\nLocal Player",
		UNBAN_BTN = "<p img='images/ui_ftf_online/ic_unban_player.tex' color=0 scale=2.5>\n\nAllow\nPlayer",

		ERROR_NO_FREE_INPUT_DEVICE = "There is no connected gamepad\nfor another player.",
		ERROR_NO_AVAILABLE_PLAYER_SLOTS = "There are 4 players already.",

		BANNED_LIST_EMPTY = "No players currently on your ban list.",

		NOTIFICATION_CODE_COPIED_TITLE = "ShareCode Copied!",
		NOTIFICATION_CODE_COPIED_TEXT = "The ShareCode %s has been copied to your clipboard.",
		NOTIFICATION_PLAYERS_SCREEN_TITLE = "Players List",
		NOTIFICATION_PLAYERS_SCREEN_TEXT = "Press <p bind='Controls.Digital.SHOW_PLAYERS_LIST' scale=0.9 color=0> to show players and ShareCode.",
		-- No SHOW_PLAYERS_LIST binding for gamepad, so be mostly accurate.
		NOTIFICATION_PLAYERS_SCREEN_TEXT_PAUSE = "Press <p bind='Controls.Digital.PAUSE' scale=0.9 color=0> to view players and ShareCode.",

		POPUP_BAN_TITLE = "Ban %s?",
		POPUP_BAN_TEXT = "Banning a player will remove them from the game session and prevent them from rejoining until they are removed from the ban list.",

	},

	ONLINESCREEN =
	{
		BACK = "Back",
		CONNECTING = "Connecting",
		END_GAME = "End Game",
		FIND_PUBLIC_GAME = "Find Public Game",
		FRIENDS_PLAYING = "Friends Playing Rotwood:",
		HOST_FRIENDS_ONLY_GAME = "Host Friends-Only Game",
		JOIN_FRIEND_GAME = "Join",
		REFRESH_FRIENDS = "Refresh Friends List",
		MODE = "Steam Friends Mode",
		CONNECT_FAILED = "Failed to connect to game.",
		JOINCODE_LABEL = "ShareCode:\n{joincode}",
		JOINCODE_LABEL_TOOLTIP = "Click to copy",
		JOINCODE_HOST = "Host Game",
		JOINCODE_JOIN = "Connect to Game",
		JOINCODE_FAILED = "Failed to find game with provided ShareCode.",
		JOINCODE_COPIED = "Copied to clipboard!" -- this is the same as the one in PAUSEMENU
	},

	NETWORKDISCONNECT =
	{
		CONFIRM_OK = "OK",
		CONFIRM_RESET = "Return To Main Menu",

		TITLE =
		{
			DEFAULT="Network Error",
		},

		BODY =
		{
			DEFAULT = "Something went wrong.",
			OK = "Everything is OK",
			InvalidGameType = "Invalid Game Type.",
			InvalidJoinCode = "Invalid ShareCode.",
			UnableToJoinLobby = "Unable to join Lobby.",
			UnableToJoinLobbyInvalidVersion = "Unable to join Lobby with a different game version.",
			JoinCodeLobbyNotFound = "Lobby not found.",
			NotOnline = "User is not online.",
			LobbyHasInvalidHost = "Invalid Host detected.",
			DisconnectedFromHost = "Disconnected from the Host.",
			UnableToCreateValidLobby = "Unable to create a valid lobby.",
			NoConnectionToServer = "No connection to server.",
			AuthorizationError = "Authorization Error.",
			LobbyNotFound = "Lobby not found, already full, or of a different version.",
			LobbyError = "Lobby encountered an error and kicked all players out.",
			Kicked = "The host kicked this client out of the game.",
			ServerTimeout = "Server timeout.",
			ServerInternalError = "Server Internal Error.",
			ServerAccessDenied = "Server Access Denied.",
			ServerLimitExceeded = "Server Limit Exceeded.",
			ServerUnknownError = "Server Unknown Error.",
			ServerFull = "The server was full.",
			PS4Error = "PS4 Specific Error.",
			PsPlusEntitlement = "PsPlus Entitlement wasn't found for given UserID.",
			PS4NetDown = "Network cable disconnected.",
			PS4RoomDestroyed = "Room was destroyed.",
			PS4UserLoggedOut = "User logged out.",
			PS4SessionNotCreatedProperly = "Session not created properly.",
			PS4UserControllerDisconnectedTimeout = "User's gamepad disconnected and remained disconnected for too long.",
			PS4UnableToReachAllMembers = "Can't reach one or more of the lobby members.",
			ConnectionTimeout = "Connection timed out.",
		},
	},

	NETWORKINVITEDISABLED =
	{
		TITLE = "Cannot Join Online Game",
		CLOSE = "Continue",
	},

	NETWORK =
	{
		PLAYER_JOINED = "Player joined.",
		PLAYER_JOINED_TEXT = "{player} joined the game.",

		PLAYER_LEFT = "Player left.",
		PLAYER_LEFT_TEXT = "{player} left the game.",
	},

	WAITINGFORPLAYERSSCREEN =
	{
		WAITING_TEXT = "Waiting for other players...",
	},

	RECIPESCREEN =
	{
		ITEM_COUNT = "x %.0f"
	},

	RESEARCHSCREEN =
	{
		ARMOR_TITLE = "%s Armour",
		ARMOR_DESCRIPTION = "Picked up %s drops allow you to upgrade this armour set.",
		ARMOR_LOCKED_DESCRIPTION = "You haven't found this creature yet.\nKeep exploring!",
		ITEM_MAXXED_OUT = "This item is fully upgraded!",
		WEAPON_LOCKED = "You haven't unlocked this weapon type yet.",
		ALREADY_OWNED = "You already own this.",
		LABEL_EQUIPPED = "<p img='images/ui_ftf_research/icon_equipped.tex' scale=1> Equipped",
		BTN_EQUIP = "Equip",
		BTN_UPGRADE = "Upgrade to Lvl %d",
		BTN_CRAFT = "Craft item!",
		BTN_UNLOCK = "UNLOCK!",
		UNLOCK_LABEL = "You haven't unlocked this armour set yet.",
		TITLE_LEVEL_UPGRADE = "%d  <#UPGRADE_DARK><p img='images/ui_ftf/arrow_right.tex' color=0 scale=0.4>  Lvl %d</>",

		UNLOCK_POPUP_TITLE = "Armour Set Unlocked!",
		UNLOCK_POPUP_DESCRIPTION_SINGLE = "You can now craft the <#RED>%s</>",
		UNLOCK_POPUP_DESCRIPTION_DOUBLE = "You can now craft the <#RED>%s</> and <#RED>%s</>",
	},

	GEMSCREEN =
	{
		UNLOCK_POPUP =
		{
			TITLE = "{name_multiple.gem}",
			DESC = "{name.npc_blacksmith} has gifted you three new <#HEALTH>{name_multiple.gem}</>!\n\nAdded to your <#HEALTH>Inventory</>:\n- {name.concept_damage} α\n- {name.concept_runspeed} α\n- Max Health α\n\n{name_multiple.gem} can be set into any <#HEALTH>Weapon</> with <#HEALTH>{name.gem} Slots</> to magically alter its stats.\n\nAfter crafting a <#HEALTH>Weapon</>, try asking {name.npc_blacksmith} to set it with a <#HEALTH>{name.gem}</>.",
		},

		GEMS_TITLE = "GEM COLLECTION",
		GEMS_EMPTY = "No {name_multiple.gem} in your inventory yet.",
		SLOTS_EMPTY = "This weapon has no {name.gem} slots.",
		INFO_LABEL = "<#LIGHT_TEXT>Press <p bind='Controls.Digital.ATTACK_HEAVY' color=0> on a slot to unset its {name.gem}.</>\n\nSlay {name_multiple.rot} to level all equipped {name_multiple.gem}.",
		TITLE_EMPTY = "Empty %s {name.gem} Slot",
		TITLE_EMPTY_ANY = "Empty {name.gem} Slot",
		DESC_EMPTY = "This slot fits any %s {name.gem}.",
		DESC_EMPTY_ANY = "This slot can fit any {name.gem}.",
		GEM_EQUIPPED_TT = "This {name.gem} is set on your <#RED>%s</>.",
		MAX_LEVEL_GEM = "MAX LEVEL",
	},

	HEARTTOOLTIP = 
	{
		HEART_LEVEL = "Level {current}/{max}",
		HEART_LEVEL_UPGRADE = "Level <#UPGRADE_DARK>{new}</>/{max}",
	},

	HEARTSCREEN =
	{
		HEARTS_TITLE = "{NAME.konjur_heart} COLLECTION",
		HEART_LEVEL = "Level {current_level}/{max_level}",
		ADD_MORE_HEARTS = "Upgrade your {name_multiple.i_konjur_heart} by defeating {name_multiple.rot_boss} in higher Frenzy Levels!",
		INTERACT = {
			BTN_PLACE_IN_WELL = "<p bind='Controls.Digital.ACTION' color=0> Feed Machine\n<#KONJUR><p img='images/ui_ftf_icons/konjur_heart.tex' rpad=1>{heartstone}</>",
			BTN_SWAP_HEARTSTONES = "<p bind='Controls.Digital.ACTION' color=0> Swap Aspect",
			BTN_ENABLE_HEARTSTONES = "<p bind='Controls.Digital.ACTION' color=0> Enable Aspect",
			BTN_DISABLE_HEARTSTONES = "<p bind='Controls.Digital.ACTION' color=0> Disable Aspect",
		},
	},

	MASTERYSCREEN =
	{
		TITLE = "MASTERIES",
		CLAIM = "CLAIM!",
		DESC = "Complete Masteries to earn rewards!",
		REWARDS = "Rewards",
		GENERAL = "General",
		OTHER = "Boss Rots",
		LOCKED = "Locked",
		NEW_MASTERY_TAB = "This tab has a new mastery!",
		NEW_MASTERY = "This mastery is new!",
		CAN_CLAIM = "This tab has a mastery you can claim!",
		PROGRESS = "Progress: %d / %d",
		PROGRESS_COMPLETE = "Completed!",
		UNLOCK_NEW_TITLE = "<p img='images/icons_ftf/character_title.tex' color=0> New Title: %s",

		POPUP = {
			MASTERY_ACTIVATED = "{mastery_name} Activated!",
			MASTERY_COMPLETED = "{mastery_name} Complete!",
		}
	},

	ARMORYSCREEN =
	{
		TITLE = "ARMOURY",
		WEIGHT = "WEIGHT",
		MAX_LEVEL = "MAX LEVEL",
		EQUIP_TT = "Press <p bind='Controls.Digital.EQUIP' color=0> to Swap",
		NO_ARMORSMITH_TT = "Rescue <#BLUE>{name.npc_armorsmith} the {name.job_armorsmith}</> in <#RED>{name.treemon_forest}</> to unlock this function",
		NO_EQUIPMENT = "No equipment",
		DEFENSE_LVL = "DEFENSE LVL: %d",
		EFFECT_LVL = "EFFECT LVL: %d",
		LOCKED_FRENZY_LVL = "This item is only found in Frenzy Levels",
		LOCKED_DESC = "Purchase in the <#RED>%s</> marketplace",
		BACK = "<p img='images/ui_ftf/arrow_left.tex' color=0 scale=0.7> Back",
	},

	DECORSCREEN =
	{
		TITLE = "DECOR",
		PICKUP = "Pick Up Items",
		NO_PERMISSION = "You need permission from the host to move things in this town!",
		BASIC_CATEGORY = "General",
		LOCKED_TT = "Locked",
	},

	HUD =
	{
		START = "ACCEPT",
		VICTORY =
		{
			BUTTON = "<p bind='Controls.Digital.NON_MODAL_CLICK' color=0> Complete Expedition",
		},
		CONTINUE = "Continue",
		TO_TOWN = "Return To Town",
		WAITING_FOR_HOST = "Waiting for Host...",
		WAITING_FOR_ALL_PLAYERS = "Waiting for all players\n%d/%d",
		WAITING_FOR_ALL_PLAYERS_NO_COUNT = "Waiting for all players",
		START_RUN_COUNTDOWN = "Starting expedition\n%d...",

		RUN_DATA = "%s", -- Location
		RUN_DATA_FRENZY = "%s [F%s]", -- Location [Frenzy]

		CANNOT_INTERACT_DEAD = "Revive all players",
		CANNOT_INTERACT_BUSY = "A player is in a menu",
		CANNOT_INTERACT_WRONG_PLAYER = "Wrong player dude!", --kris

		CANNOT_PLACE_PROP =
		{
			OCCUPIED = "<#RED>Space Occupied</>",
			CRITICAL_PATH = "<#RED>Impedes Path</>",
		},

		PICKUP_INSTRUCTIONS = "<p bind='Controls.Digital.CLICK_PRIMARY' color=0> Pick up",
		PLACE_INSTRUCTIONS = "<p bind='Controls.Digital.CLICK_PRIMARY' color=0> Place \n<p bind='Controls.Digital.FLIP_PLACER' color=0> Flip \n<p bind='Controls.Digital.CLICK_SECONDARY' color=0> Move to Inventory",

		HITCOUNTER = {
			HIT_STREAK = "HITS",
			DAMAGE_SUM = "DMG",
		},

		ENCOURAGE_FEEDBACK = "Press F8 to send feedback!",

		EXPLAIN_CHAT = "Press <p bind='Controls.Digital.TOGGLE_SAY' color=0> to chat",
	},

	CONSOLESCREEN =
	{
		REMOTEEXECUTE = "Remote:",
		LOCALEXECUTE = "Local:",
	},

	ROOMBONUSSCREEN =
	{
		TITLE = "CHOOSE A {NAME.concept_relic}",
		TITLE_SKILL = "CHOOSE A {NAME.concept_skill}",
		RESTRICTION = "Each player must pick a different effect.",
		CONTINUE_BUTTON_POWER = "Pick {name.concept_relic}",
		CONTINUE_BUTTON_SKILL = "Pick {name.concept_skill}",
		CONTINUE_BUTTON_POWER_TT = "Select a {name.concept_relic} first",
		CONTINUE_BUTTON_SKILL_TT = "Select a {name.concept_skill} first",
		SKIP_BUTTON_POWER = "<p bind='Controls.Digital.MENU_REJECT' color=0> Skip {name.concept_relic}",
		SKIP_BUTTON_SKILL = "<p bind='Controls.Digital.MENU_REJECT' color=0> Skip {name.concept_skill}",
		SKIP_BUTTON_KONJUR = "+%s <p img='images/ui_ftf_icons/konjur.tex'>",
		SKIP_BUTTON_SKILL_KEEP = "KEEP %s",
		SKILL_TIP = "Use your {name.concept_skill} by pressing <p bind='Controls.Digital.SKILL' color=BTNICON_DARK>",
		CURRENT_SKILL_INFO = "Picking a new {name.concept_skill} will replace the one you currently have.",
	},

	UNITFRAME =
	{
		POTION_TOOLTIP = "<#RED>Drink</>: (Hold <p bind='Controls.Digital.USE_POTION' color=BTNICON_DARK>)\n<#RED>Shop</>: %i<p img='images/ui_ftf_icons/konjur.tex'>",
		FOOD_TOOLTIP = "<#RED>Food Power:</>\n%s\n%s",
		SKILL_TOOLTIP = "<#RED>{name.concept_skill}:</> (<p bind='Controls.Digital.SKILL' color=BTNICON_DARK>)\n%s\n%s",
		WAITING_TO_JOIN = "Waiting to join safely!",
	},

	KONJURSOULSWIDGET =
	{
		NUM = "%d <#KONJUR>{name.i_konjur}</>",
	},

	PRICEWIDGET =
	{
		NOT_ENOUGH = "Insufficient <#KONJUR>{name.i_konjur}</>"
	},

	LOADINGINDICATOR =
	{
		LOADING_TEXT = "Loading..."
	},

	POWERICONWIDGET =
	{
		UPGRADE = "Can be upgraded."
	},

	COLLABERATIVECRAFT =
	{
		CONTRIBUTE = "Contribute Materials?"
	},

	POWERSELECTIONSCREEN =
	{
		POWER_PROMPT_RELIC = "<p bind='Controls.Digital.ACTION' color=0>  Select {name.concept_relic}",
		POWER_PROMPT_SKILL = "<p bind='Controls.Digital.ACTION' color=0>  Select {name.concept_skill}",
		POWER_PROMPT_FABLED_RELIC = "<p bind='Controls.Digital.ACTION' color=0>  Select {category} {name.concept_relic}",
		POWER_PROMPT_SOUL = "<p bind='Controls.Digital.ACTION' color=0>  Take",

		TITLE_POWER = {
			-- These are ConfirmAction keys in PowerConfirmationScreen.
			Select = "Select a <#RED>{name.concept_relic}</>",
			Upgrade = "Upgrade a <#RED>{name.concept_relic}</>",
			Remove = "Remove a <#RED>{name.concept_relic}</>",
		},
		TITLE_SKILL = {
			Select = "Select a <#RED>{name.concept_skill}</>",
			Upgrade = nil, -- Can't Upgrade Skills.
			Remove = "Remove a <#RED>{name.concept_skill}</>",
		},
		BACK_BUTTON = "<p img='images/ui_ftf_dialog/convo_back.tex' scale=1.3 color=0> Back",
		CANCEL_BUTTON = "Done",
		CONFIRM_BUTTON = "Confirm",
		UPGRADE_BUTTON = "<p img='images/ui_ftf_dialog/convo_upgrade_power.tex' scale=1.2 color=0> Upgrade",
		UPGRADE_BUTTON_PRICE = "<p img='images/ui_ftf_icons/konjur.tex'>%d",
		REMOVE_TITLE = "Remove this <#RED>{name.concept_relic}</>?",
		REMOVE_BUTTON = "<p img='images/ui_ftf_dialog/convo_remove_power.tex' scale=1.2 color=0> Remove <#RED>{name.concept_relic}</>",
		NOT_ENOUGH = "Insufficient <#KONJUR>{name.i_konjur}</>",
		REMOVE_POWER = "Permanently remove this <#RED>{name.concept_relic}</>",
	},

	WEAPONSELECTIONSCREEN =
	{
		TITLE = "%s Rack",
		ATTACK_LVL = "ATTACK LVL: %d",
		SKILL_LVL = "EFFECT LVL: %d",
		NO_BLACKSMITH_TT = "Rescue <#BLUE>{name.npc_blacksmith} the {name.job_blacksmith}</> to unlock this function",
		NO_BLACKSMITH_HAS_LOCATION_TT = "Rescue <#BLUE>{name.npc_blacksmith} the {name.job_blacksmith}</> in <#RED>{name.owlitzer_forest}</> to unlock this function",
		UPGRADE_BUTTON = "Fortify", --using an ingot to upgrade a piece of gears level
		LEVEL_INFO_MAX = "<p img='images/ui_ftf/ButtonUpgraded.tex'> Item at Max Level",
	},

	INVENTORYCHESTSCREEN =
	{
		TITLE = "Inventory",
	},

	INVENTORYSCREEN =
	{
		BUTTON_LABEL = "INVENTORY",
		MENU_TITLE = "INVENTORY",
		NO_ITEM_SELECTED = "No item selected",
		TITLE_UNLOCKED = "NEW TITLE AVAILABLE:\n\"%s\"",
		ITEM_REWARD_POPTEXT = "<p img='images/hud_images/hud_%s_drops_currency.tex'> %d", --"%s" is the material icon, %d is the number
		LOOT_PICKUP_POPTEXT = "+<p img='%s'> %s", --"%s" is the material icon, %s is the name
		KONJUR    = "<p img='images/hud_images/hud_konjur_drops_currency.tex'> %d",
		KONJUR_SOUL_LESSER = "<p img='images/hud_images/hud_konjur_soul_lesser_drops_currency.tex'> %d",
		KONJUR_SOUL_GREATER = "<p img='images/hud_images/hud_konjur_soul_greater_drops_currency.tex'> %d",
		KONJUR_HEART = "<p img='images/hud_images/hud_konjur_heart_drops_currency.tex'> %d",
		PRESETS = "Presets",
		EMPTY_LIST_INFO = "You don't own any items in this category",
		UNEQUIP_WEAPON_TT = "Can't unequip weapons.\nYou must have a weapon equipped at all times.",
		DISCARD_TT = "Discard item permanently.",
		DISCARD_EQUIPPED_ITEM_TT = "Can't discard equipped items.",
		EQUIP = "EQUIP",
		UNEQUIP = "UNEQUIP",
		EQUIP_TT =   "<p bind='Controls.Digital.EQUIP' color=0> to Equip",
		UNEQUIP_TT = "<p bind='Controls.Digital.EQUIP' color=0> to Unequip",
		UNEQUIP_SLOT_TT = "<p bind='Controls.Digital.UNEQUIP' color=0> to Unequip",
		DISCARD_ITEM = "DISCARD",
		DISCARD_ONE = "DISCARD 1",
		DISCARD_ALL = "DISCARD ALL (%d)",
		DESCRIPTION_QUANTITY_SUFFIX = "%s\n<#B69655>Quantity: %d</>",
		WRAP_SLOT_TITLE = "CUSTOM WRAP",
		WRAP_SLOT_SUBTITLE_EMPTY = "NONE",
		WRAP_EMPTY_TT = "This item doesn't have a wrap applied.\nA wrap can be fashioned to this item by an artisan.",
		SLOTS_TITLE = "EQUIPMENT SLOTS",
		NOSLOTS_TT = "This item doesn't have equipment slots.\nItems with equipment slots can have materials attached to them by an artisan for various beneficial effects.",
		SLOT_EMPTY_TT = "This slot doesn't have any material applied.\nA material can be attached to this item by an artisan for various beneficial effects.",
		DISCARD_DIALOG_TITLE = "Discard item?",
		DISCARD_DIALOG_SUBTITLE = "%s",
		DISCARD_DIALOG_TEXT = "Discarding this item will remove it permanently from your inventory.\nAre you sure you want to remove it?",
		DISCARD_ALL_DIALOG_TITLE = "Discard %d items?",
		DISCARD_ALL_DIALOG_SUBTITLE = "%s",
		DISCARD_ALL_DIALOG_TEXT = "Discarding these items will remove them permanently from your inventory.\nAre you sure you want to remove all of this item?",
		UPGRADE_WIDGET = "%d/%d Upgrades",
		UPGRADE_WIDGET_TT = "Upgrades can be performed by skilled metalworkers.\nA whitesmith can apply upgrades up to each item's limit. These improve on the item's original performance.",
		SAVECHANGES_DIALOG_TITLE = "Save changes?",
		SAVECHANGES_DIALOG_SUBTITLE = "Equipment changed",
		SAVECHANGES_DIALOG_TEXT = "You've changed your equipped gear.\nWant to save those changes, or go back to what you were carrying before?",
		SAVECHANGES_DIALOG_YES_BUTTON = "SAVE",
		SAVECHANGES_DIALOG_NO_BUTTON = "REVERT",
		FILTER = "...",
		FOOD_POWER_EXPLANATION = "WHEN CONSUMED, GAIN<#LIGHT_TEXT>%s</>:",
		TONIC_POWER_EXPLANATION = "WHEN YOU DRINK, GAIN<#LIGHT_TEXT>%s</>:",

		WEIGHT_LIGHT = "L",
		WEIGHT_NORMAL = "M",
		WEIGHT_HEAVY = "H",

		WEIGHT_TOOLTIP_LIGHT = "<#BLUE>{name.light_weight} Class</>\n<z 0.9>A lightweight build with a quick <#RED>{name.concept_dodge}</> and shorter invulnerability period</>",
		WEIGHT_TOOLTIP_MEDIUM = "<#BLUE>{name.medium_weight} Class</>\n<z 0.9>A medium-weight build with an even spread of speed, <#RED>{name.concept_damage}</>, and <#RED>{name.concept_damage} Resistance</></>",
		WEIGHT_TOOLTIP_HEAVY = "<#BLUE>{name.heavy_weight} Class</>\n<z 0.9>A heavyweight build with high <#RED>{name.concept_damage} Resistance</> and low speed</>",

		-- These are not necessarily *new* weight class ratings, but they -could- be new
		-- I can give you that much resolution if you'd like
		WEIGHT_TOOLTIP_PREVIEW_LIGHT = "Equipping this item will result in an <#BLUE>{name.light_weight} Class</> build\n<z 0.9>This will give you a quick <#RED>{name.concept_dodge}</> with a shorter invulnerability period</>",
		WEIGHT_TOOLTIP_PREVIEW_MEDIUM = "Equipping this item will result in a <#BLUE>{name.medium_weight} Class</> build\n<z 0.9>This will give you an even spread of speed, <#RED>{name.concept_damage}</>, and <#RED>{name.concept_damage} Resistance</></>",
		WEIGHT_TOOLTIP_PREVIEW_HEAVY = "Equipping this item will result in a <#BLUE>{name.heavy_weight} Class</> build\n<z 0.9>This will give you high <#RED>{name.concept_damage} Resistance</> and low speed</>",
	},

	DUNGEONSELECTIONSCREEN = {
		CONFIRM_TRAVEL = {
			TITLE = "Travel to this location?",
			YES = "Onwards!",
			NO = "Wait a minute.",
		},
		FRENZY_WIDGET =
		{
			BASE_DIFFICULTY_TITLE = "Standard",
			FRENZY_LEVEL_TITLE = "Frenzy {level}",

		}
	},

	DUNGEONSUMMARYSCREEN =
	{
		POWERS_TITLE = "POWERS",
		LOOT_TITLE = "LOOT",
		MASTERIES_TITLE = "MASTERIES",
		STATS_TITLE = "STATISTICS",
		LOOT_EMPTY = "You didn't grab any loot this time.",
		MASTERY_EMPTY = "You didn't progress any masteries.",
		POWER_EMPTY = "You didn't collect any {name_multiple.concept_relic}.",
		DURATION_TITLE = "YOUR EXPEDITION TOOK",
		TOTAL_KILLS = "KILLS",
		ROOMS_LABEL = "CHAMBERS\nDISCOVERED",
		ROOMS_LABEL_STAT = "CHAMBERS DISCOVERED",
		DAMAGE_DONE = "DAMAGE DONE",
		DAMAGE_TAKEN = "DAMAGE TAKEN",
		DAMAGED_BY = "MOST DAMAGE DEALT BY",
		DAMAGED_BY_EMPTY = "MOST DAMAGE DEALT BY",
		DAMAGED_VALUE_EMPTY = "Environment",
		DAMAGED_BY_NONE = "DAMAGE RECEIVED",
		DAMAGED_VALUE_NONE = "None!",
		DEATHS = "TIMES DIED",
		KONJUR_CONVERSION_TT = "<#KONJUR>%s %s</> was converted into <#KONJUR>%s %s</>",
		POWER_REWARD_UNLOCKED = "New potential {name.concept_relic} added to {name_multiple.concept_relic} pool!",
		LOADING_TEXT = "Loading details...",
		MAX_META_LEVEL = "MAX",
	},

	DUNGEONLEVELWIDGET =
	{
		PROGRESS_VALUE = "<#LIGHT_TEXT_DARKER>%d</><#LIGHT_TEXT_DARK>/%d</>",
		REWARD_UNLOCKED = "Unlocked!",
	},

	MAPSCREEN =
	{
		START_DUNGEON_RUN = "Start Dungeon Run",
		RESET_PATH = "Reset Path",
		TOWN = "Town",
		UNKNOWN_CREATURE = "Undiscovered Rot",
		UNKNOWN = "???",

		RECOMMENDED_ATTACK_LABEL = "Recommended",
		ATTACK_VALUE = "<p img='images/icons_ftf/stat_weapon.tex' color=0 scale=1>%d",
		CURRENT_ATTACK = "Current: <p img='images/icons_ftf/stat_weapon.tex' color=0 scale=1>%d",
		RECOMMENDED_DEFENSE_LABEL = "Recommended",
		DEFENSE_VALUE = "<p img='images/ui_ftf/ic_stat_defend.tex' color=0 scale=1>%d",
		CURRENT_DEFENSE = "Current: <p img='images/ui_ftf/ic_stat_defend.tex' color=0 scale=1>%d",

		RECOMMENDED_POWER = "RECOMMENDED POWER: %d",

		LOCATION_BOSSES_GRID_TITLE = "{NAME_MULTIPLE.rot}",
		LOCATION_MATERIALS_GRID_TITLE = "MATERIALS",
		LOCATION_DROPS_GRID_TITLE = "ITEMS",
		LOCATION_LOCKED_TITLE = "Location Locked",

		LOCKED_INFO_LABEL = "<p img='images/map_ftf/lock_icon.tex' color=0 scale=4>\n\n\nDefeat the local Boss to unlock\nFrenzy Levels.",
		LOCKED_REGION_ERROR = "This location hasn't been found by:\n%s",

		TRAVEL_BUTTON = "FLY THERE!",
		CHANGE_WEAPON = "Change Weapon",
	},

	FORGEWEAPONSCREEN =
	{
		MENU_TITLE = "Forge Weapon",
		PANEL_TITLE = "Forge %s",
		MAX_SLOTS_HELPTEXT = "This weapon can be crafted with a maximum of %s slot(s).",
		MAX_UPGRADES_HELPTEXT = "This weapon can be upgraded a maximum of %s time(s).",
		CAN_APPLY_WRAP_HELPTEXT = "This weapon can be wrapped.",
		CANNOT_APPLY_WRAP_HELPTEXT = "This weapon cannot be wrapped.",
	},

	FORGEARMORSCREEN =
	{
		MENU_TITLE = "Forge Armour",
		MAX_SLOTS_HELPTEXT = "This armour can be crafted with a maximum of %s slot(s).",
		MAX_UPGRADES_HELPTEXT = "This armour can be upgraded a maximum of %s time(s).",
		CAN_APPLY_WRAP_HELPTEXT = "This armour can be wrapped.",
		CANNOT_APPLY_WRAP_HELPTEXT = "This armour cannot be wrapped.",

		STATS_CREATURES_TITLE = "Armour sets unlocked",
		STATS_CREATURES_VALUE = "%d/%d",
		STATS_HEAD_TITLE = "Hat upgrades",
		STATS_HEAD_VALUE = "%d/%d",
		STATS_BODY_TITLE = "Armour upgrades",
		STATS_BODY_VALUE = "%d/%d",
	},

	FOODSCREEN =
	{
		MENU_TITLE = "Food Menu",
	},

	CREATEELIXIRSCREEN =
	{
		MENU_TITLE = "APOTHECARY",
	},

	MIXPOTIONSCREEN =
	{
		MENU_TITLE = "Alchemist",
		CONTENTS = "Potion Contents",
		ELIXIRS = "Elixirs",
		MIX_UP = "Mix Up",
		MIX_DOWN = "Mix Down",
		MIX_ADD = "Add to Mix",
		MIX_REMOVE = "Remove from Mix",
	},

	CREDITSSCREEN =
	{
		TITLE = "CREDITS",
		OPENSOURCE = "OPEN SOURCE PACKAGES"
	},

	EQUIPMENT_STATS =
	{

		DMG =
		{
			name = "WEAPON DAMAGE",
			desc = "The base number that all <#RED>Weapon {name.concept_damage}</> modifiers will be applied to.",
		},
		DMG_MULT =
		{
			name = "WEAPON DAMAGE MULTIPLIER",
			desc = "Multiplies <#RED>Weapon {name.concept_damage}</>.",
		},
		ARMOUR =
		{
			name = "DMG REDUCTION",
			desc = "Reduces the amount of <#RED>{name.concept_damage}</> you take when hit.", --\n\nIncoming <#RED>Damage</> reduced by <#RED>%.1f%%</>.",
			desc_negative = "Reduces the amount of <#RED>{name.concept_damage}</> you take when hit.", --\n\n<#RED>Incoming Damage increased by <b>%.1f%%</>!</>",
		},
		HP =
		{
			name = "HEALTH",
			desc = "All that ultimately stands between you and <#RED>Death</>.",
		},
		CRIT =
		{
			name = "CRITICAL CHANCE",
			desc = "Your chance to perform a <#RED>Critical Attack</>.",
		},
		CRIT_MULT =
		{
			name = "CRITICAL DAMAGE",
			desc = "The amount by which a <#RED>Critical Hit</> multiples outgoing <#RED>{name.concept_damage}</>.\n\n<#RED>Critical Hits</> deal <#RED>%.1f%% {name.concept_damage}</>.",
		},
		FOCUS_MULT =
		{
			name = "FOCUS DAMAGE",
			desc = "A <#RED>{name.concept_damage}</> multiplier specifically applied to your <#BLUE>{name.concept_focus_hit}</>.\n\n<#BLUE>{name.concept_focus_hit}</> will deal an additional <#RED>%.1f%% {name.concept_damage}</>.",
		},
		LUCK =
		{
			name = "LUCK",
			desc = "The chance of good things happening to you.",
		},
		SPEED =
		{
			name = "{NAME.concept_runspeed}",
			desc = "Modifies how quickly you move.",
		},


		DURABILITY =
		{
			name = "DURABILITY",
			desc = "",
		},
		WEIGHT =
		{
			name = "WEIGHT",
			desc = "",
		},
		WRAP =
		{
			name = "WRAP",
			desc = "",
		},
		QUANTITY =
		{
			name = "QUANTITY",
			desc = "",
		},
		RARITY =
		{
			name = "RARITY",
			desc = "The quality of the item.",
		},
		ILVL =
		{
			name = "ITEM LEVEL",
			desc = "The item's level.",
		},
		LIFETIME =
		{
			name = "LIFETIME",
			desc = "The amount of time until this item is inedible.",
			expires = "Expires in",
			day = "day",
			days = "days",
		},
		SOURCE =
		{
			name = "SOURCE",
			desc = "Where this item came from",
		}
	},

	CRAFTING =
	{
		REQUIRED_MATERIALS = "Required Materials",
		OWNED = "OWNED",
		DENSITY = "Density",
		CAN_CRAFT = "Can Craft",
		RECIPE_DESCRIPTION = "<p img='images/ui_ftf_crafting/RecipeDescriptionBefore.tex' color=C2AD9730 scale=1.2>%s<p img='images/ui_ftf_crafting/RecipeDescriptionAfter.tex' color=C2AD9730 scale=1.2>",
	},

	ITEMS =
	{
		TOOLTIP =
		{
			MAX_USES = "Charges: <#RED>%s</>",
		},
	},

	BUTTONS =
	{
		OK = "OK",
		NO = "NO",
		CANCEL = "Cancel",
		CLOSE = "Close",
		SELECT = "Select",
		NEXT = "Next",
		PREVIOUS = "Previous",

		EQUIP = "Equip",
		UNEQUIP = "Unequip",

		BUY_INFO = "Buy Info",

		FORGE = "Forge",
		MIX = "Mix",
		CREATE = "Create",
		UPGRADE = "Upgrade",
	},

	ACTIONS =
	{
		TALK = "Talk",
		VIEW_MAP = "View Map",
		HEAD_OUT = "Head Out?",
		HEAD_OUT_CONFIRM = "Head Out",
		CANCEL = "Cancel",
		PRACTICE_FIGHT = "Reminisce",
		OPEN_ARMOR_SHOP = "Forge Armour",
		OPEN_WEAPON_SHOP = "Forge Weapon",
		MOVE_IN = "Move In",
		REVIVE = "<p bind='Controls.Digital.ACTION' color=0> Revive",
		REVIVING = "<p bind='Controls.Digital.ACTION' color=0> Reviving",
		TAKE_POWERITEM = "<p bind='Controls.Digital.ACTION'> Take",
		OPEN_STORAGE = "<p bind='Controls.Digital.ACTION' color=0> Open Inventory"
	},

	MISC =
	{
		DONE = "Done!",
		EMPTY = "[Empty]",
	},

	WARE_PURCHASE_POPUP =
	{
		-- Deciding whether they want to purchase or not
		DECISION_TITLE = "Purchase item?",
		DECISION_TITLE_PENDING = "Purchasing item!",
		DECISION_TEXT = "Would you like to purchase this item?",
		PURCHASE_OPTION = "Purchase <p img='images/hud_images/hud_konjur_soul_lesser_drops_currency.tex'> %d", -- amount of corestones
		CANCEL_OPTION = "Nevermind!",

		-- They're about to purchase it -- they can either equip it, ship it home, or back out here (click X)
		TEXT = "Would you like to wear this now, or ship it home?",
		EQUIP_OPTION = "Equip It",
		SHIP_OPTION = "Ship It",

		-- They have bought it but shipped it home -- popup window explaining this.
		-- This would eventually be replaced with (TODO: what?)
		SHIPPED_TITLE = "Thank-you for your patronage!",
		SHIPPED_TEXT = "Your item will be waiting for you back in town.",
		SHIPPED_OK = "OK",

		WEIGHT_CHANGED_TO = {
			LIGHT = "(Weight Class will change to <#RED>{name.light_weight}</>)",
			MEDIUM = "(Weight Class will change to <#RED>{name.medium_weight}</>)",
			HEAVY = "(Weight Class will change to <#RED>{name.heavy_weight}</>)",
		},
	},

	DYE_PURCHASE_POPUP =
	{
		-- They're about to purchase it -- they can apply it immediately if they are wearing the armour.
		TEXT = "Would you like to apply it now?",
		YES_OPTION = "Yes",
		NO_OPTION = "No",
	},

	VENDING_MACHINE =
	{
		DYE_LABEL = "%s\nDye #%d",
		HEALING_FOUNTAIN = "Five-Finger Brew",
		DEPOSIT = "<p bind='Controls.Digital.ACTION'> Deposit",
		PURCHASE = "<p bind='Controls.Digital.ACTION'> Purchase",
		LOOT_FMT = "<p bind='Controls.Digital.ACTION'> Purchase\n({icon} {available} Owned)",

		-- Verb for taking health from the "healing fountain" in the potion room.
		SAMPLE_HEALING_FOUNTAIN = "<p bind='Controls.Digital.ACTION'> \"Free\" Sample?",

		REFUND = "Refund!", -- TODO @chrisp #deadcode - this is for in-world refunds, which are currently unused
		ARMOUR_UNOWNED = "Must own armour piece",
		ALREADY_PURCHASED = "Already owned",
		EMPTY_HEALING_FOUNTAIN = "(Can't steal more)",
		
		WEAPON_LOCKED = {
			HAMMER = "{name.weapon_hammer} is locked\n(Unlock in town)",
			POLEARM = "{name.weapon_polearm} is locked\n(Unlock in town)",
			GREATSWORD = "{name.weapon_greatsword} is locked\n(Unlock in town)",
			CANNON = "{name.weapon_cannon} is locked\n(Unlock in town)",
			SHOTPUT = "{name.weapon_shotput} is locked\n(Unlock in town)",
			PROTOTYPE = "{name.weapon_hammer} is locked\n(Unlock in town)",
		},

		INSUFFICIENT_FUNDS = {
			DEFAULT = "Need more {icon}",
			HEALTH = "Full Health",
		},

		SHOP_INVENTORY =
		{
			potion = "{name.potion} Refill",
			upgrade = "{name.concept_relic} Upgrade",
			shield = "{name.concept_shield}",
		},
	},

	META_PROGRESS = {
		REWARD_STATUS = "{reward}: {xp}/{xp_target} EXP",
		TAKE_REWARDS = "<p bind='Controls.Digital.ACTION'> Get Treasure Bundle!",
		WEAPON_RACK = "<p bind='Controls.Digital.ACTION' color=0> {weapon} Rack",
		DEPOSIT = "<p bind='Controls.Digital.ACTION'> Burn",
		NO_CORESTONES = "No {name.konjur_soul_lesser}",
		NOT_MINE = "Prohibited\n{name.dgn_resource_converter}",
		NOT_ENOUGH_XP = "Keep Hunting\nto Level Up",
	},

	--strings for why things can't be picked up
	SHOP_ITEM = {
		POWER = {
			NOT_MINE = "Wrong Hunter",
			FULLY_UPGRADED = "{name.concept_relic} Maxed",
			LIMIT_REACHED = "One Fabled {name.concept_relic}\nPer Hunter" --#pickups - fabled powers are dropped as a pool, all available for pickup by all players, but only one per
		},
		POTION = {
			ALREADY_OWNED = "Potion Full",
		},
		UPGRADE = {
			NO_UPGRADEABLE_POWERS = "No Upgradeable Power",
		},
		SHIELD = {
			AT_MAXIMUM = "Shield Maxed",
		},
	},

	MAP_ICONS =
	{
		MINIBOSS = "Something wicked this way comes",
		FOOD = "Fill your stomach!",
		QUEST = "Meet new friends and move the story forward",
		POTION = "Quench your thirst and restore your health",
		MARKET = "Buy armor, new weapons and resources!",
		METAUNLOCK = "New unlocks right ahead",
		POWERUPGRADE = "Upgrade your powers",
		SPECIALEVENT = "???",
		BOSS_MEGATREEMON = "Something dangerous lies ahead",
		BOSS_BANDICOOT = "Something dangerous lies ahead",
		BOSS_THATCHER = "Something dangerous lies ahead",
		BOSS_OWLITZER = "Something dangerous lies ahead",
		COIN1 = "Konjur rewards for your shopping needs",
		COIN2 = "Challenge ahead!\nKonjur rewards for your shopping needs",
		PLAIN1 = "Get a new power!",
		PLAIN2 = "Challenge ahead!\nGet a new power!",
		FABLED1 = "Get a special power!",
		FABLED2 = "Challenge ahead!\nGet a special power!",
		SKILL1 = "Get yourself a new skill!",
		SKILL2 = "Challenge ahead!\nGet yourself a new skill!",
		SMALLTOKEN1 = "Corestones for your shopping needs",
		SMALLTOKEN2 = "Challenge ahead!\nCorestones for your shopping needs",
		BIGTOKEN1 = "", -- Not used yet
		BIGTOKEN2 = "", -- Not used yet
		MATERIAL1 = "Loot and materials for your crafting needs",
		MATERIAL2 = "Challenge ahead!\nLoot and materials for your crafting needs",
	},
}

STRINGS.UI.CRASH_STATUS = {
	-- Keys match what backend sends to us.
	NEEDS_MORE_INFO = "Known, but we need help tracking it down. If you'd like to help, click 'Bug Tracker' and follow the instructions.",
	FIXED = "Fixed in an upcoming release.",
	KNOWN_ISSUE = "Known, and we hope to resolve it soon.",
}

STRINGS.BIOMES = {
	town =
	{
		name = "Town",
		desc = "",
	},
	forest =
	{
		name = "Forest",
		desc = "",
	},
	swamp =
	{
		name = "Swamp",
		desc = "",
	},
	desert =
	{
		name = "Desert",
		desc = "",
	},
	coral =
	{
		name = "Coral",
		desc = "",
	},
	tundra =
	{
		name = "Tundra",
		desc = "",
	},
	volcano =
	{
		name = "Volcano",
		desc = "",
	},
	crystal =
	{
		name = "Crystal",
		desc = "",
	},
}

STRINGS.LOCATIONS = {
	LOCKED_LOCATION_DEFAULT = "The path ahead has been lost to time, though an inspired scout could find a way.",

	LOCKED_LOCATION_NO_CLEARANCE = "Hunters without clearance:",

	brundle = {
		name = "{name.brundle}",
		--desc = "Your encampment! Vestiges of past Folkling civilizations speckle the clearing to suggest an enigmatic history. Most importantly, it's a safe haven from {name_multiple.rot}. Best aim to keep it that way.",
	},

	bandi_swamp = {
		name = "{name.bandi_swamp}",
		name_upper = "{NAME.bandi_swamp}",
		--desc = "A marshland whose plantlife once attracted as many alchemists as it currently does insects.\n\n{name.npc_scout} warns that a rascal with a malicious streak has staked its claim on the territory in the years since.",
	},
	thatcher_swamp = {
		name = "{name.thatcher_swamp}",
		name_upper = "{NAME.thatcher_swamp}",
		--desc = "NO DESC",
	},
	treemon_forest = {
		name = "{name.treemon_forest}",
		name_upper = "{NAME.treemon_forest}",
		--desc = "Years of {name.konjur} corruption have turned these once-peaceful woods into a gnarled den of monsters.\n\n{name.npc_scout} believes a single powerful {name.rot} is driving the overgrowth that plagues the forest.",
	},
	owlitzer_forest = {
		name = "{name.owlitzer_forest}",
		name_upper = "{NAME.owlitzer_forest}",
		--desc = "A secluded grove with a dreamlike air, cradled in the depths of the {name.treemon_forest}.\n\n{name.npc_scout} has made note of a massive nest located at its center.",
	},
	sedament_tundra = {
		name = "{name.sedament_tundra}",
		name_upper = "{NAME.sedament_tundra}",
		--desc = "",
	},

}

STRINGS.PSN = "PlayStation\226\132\162Network"

STRINGS.UI.HELP =
{
	MENU_SCROLL_BACK = "Scroll Up",
	MENU_SCROLL_FWD = "Scroll Down",
	PREVVALUE = "Previous Value",
	NEXTVALUE = "Next Value",
	CHANGEVALUE = "Change Value",
	REVERT = "Revert Changes",
	ACCEPT = "Accept Changes",
	APPLY = "Apply",
	SELECT = "Select",
	BACK = "Back",
	CHANGECHARACTER = "Change Character",
	PREVPAGE = "Prev Page",
	NEXTPAGE = "Next Page",
	PREV = "Previous",
	NEXT = "Next",
	CHANGEPAGE = "Change Page",
	ZOOM_IN = "Zoom In",
	ZOOM_OUT = "Zoom Out",
	TOGGLE = "Toggle",
	RANDOM = "Random",
	CONFIGURE = "Configure",
	SAVEPRESET = "Save Preset",
	SCROLL = "Scroll",
	ENTER_TEXT = "Enter Text",
	CHANGE_TEXT = "Change Text",
	CHANGE_TAB = "Change Tab",
	SHOWCHAT = "Show the Chat Tab",
	SHOWPLAYERS = "Show the Players Tab",
	VIEWGROUP = "View Group Page",
	SERVERACTIONS = "More Server Actions",
	CANCEL = "Cancel",
	CHANGE_MESSAGE = "Change Message",
}

STRINGS.CONTROL_BINDINGS = {
	-- Correspond to controls.lua
	OPEN_CRAFTING = "Crafting",
	OPEN_INVENTORY = "Inventory",
	INTERACT = "Interact",
	SHOW_EMOTE_RING = "Emote",
	LIGHT_ATTACK = "Light Attack",
	HEAVY_ATTACK = "Heavy Attack",
	DODGE = "Dodge",
	USE_POTION = "Potion",
	SKILL = "{name.concept_skill}",
	SHOW_PLAYER_STATUS = "Show Player Status", -- your status
	SHOW_PLAYERS_LIST = "Player List",  -- list of all players
	UNEQUIP = "Unequip",
	EQUIP = "Equip",
	TOGGLE_SAY = "Chat",
}

STRINGS.UI.OPTIONSSCREEN =
{
	CLOSE_BUTTON = "Back",
	SAVE_BUTTON = "Save",

	NAVBAR_GAMEPLAY = "Gameplay",
	NAVBAR_GRAPHICS = "Graphics",
	NAVBAR_AUDIO = "Audio",
	NAVBAR_CONTROLS = "Controls",
	NAVBAR_OTHER = "Other",

	CONFIRM_TITLE = "Save Changes?",
	CONFIRM_SUBTITLE = "Options changed",
	CONFIRM_TEXT = "Save your changes or discard them?",
	CONFIRM_OK = "Save",
	CONFIRM_NO = "Discard",
	CONFIRM_RESTART = "Restart",
	CONFIRM_LANGUAGE_TITLE = "Save and Restart?",
	CONFIRM_LANGUAGE_SUBTITLE = "Language changed",
	CONFIRM_LANGUAGE_TEXT = "You must restart the game to switch languages.",

	SAVED_OPTIONS_LABEL = "Options saved!",

	SETTINGS = {
		CONTROLS = {
			GAMEPLAY_VIBRATION = {
				ON = {
					NAME = "ON",
					DESC = "Allow gamepads to rumble and vibrate.",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Gamepads will not rumble or vibrate.",
				},
			},
			GAMEPLAY_MOUSE_AIMING = {
				ON = {
					NAME = "ON",
					DESC = "Player will turn to face the mouse cursor.",
				},
				OFF = {
					NAME = "OFF",
					DESC = "The mouse cursor position will not affect movement or combat.",
				},
			},
			MOUSE_CONSTRAIN_MODE =
			{
				TITLE = "Constrain Mouse",
				OFF =
				{
					NAME = "Off",
					DESC = "Mouse cursor can freely leave the game window.",
				},
				FULLSCREEN =
				{
					NAME = "Only Fullscreen",
					DESC = "Mouse cursor cannot leave the game when in fullscreen mode, but is free when windowed.",
				},
				ALWAYS =
				{
					NAME = "Always",
					DESC = "Mouse cursor cannot leave the game window.",
				},
			},

			RESET_BINDINGS = {
				TITLE = "Reset Bindings",
				DESC = "Click to reset gamepad and keyboard input bindings to their default values. This will leave your other settings and progression intact.",
				CONFIRM = "Reset input bindings?",
				YES = "Reset",
				NO = "Cancel",
			},
		},
		VIDEO = {
			CURSOR_SIZE = {
				TITLE = "Mouse Cursor",
				SYSTEM = {
					NAME = "System",
					DESC = "Use the system's mouse cursor instead of the game's stylized cursors.",
				},
				SMALL = {
					NAME = "Small",
					DESC = "Smallest mouse cursor.",
				},
				NORMAL = {
					NAME = "Normal",
					DESC = "Standard size mouse cursor.",
				},
				LARGE = {
					NAME = "Large",
					DESC = "Largest mouse cursor.",
				},
			},
			FULLSCREEN = {
				TITLE = "Borderless Fullscreen",
				ON = {
					-- This name is not currently displayed.
					--~ NAME = "Borderless Fullscreen",
					DESC = "Game window fills the screen and has no borders",
				},
				OFF = {
					--~ NAME = "Windowed",
					DESC = "Game window can be resized and repositioned on the screen",
				},
			},
			MAX_RESOLUTION = {
				TITLE = "Maximum Resolution",
				DESC = "The maximum vertical resolution that the game will render at independent of screen size.",
				VALUES = {
					RES_720 = "720p",
					RES_1080 = "1080p",
					RES_1440 = "1440p",
					RES_2160 = "2160p",
				}
			},
			BLOOM = {
				TITLE = "Bloom",
				ON = {
					NAME = "ON",
					DESC = "Glow effects are drawn around certain visual elements <b>(Recommended)</b>",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Bloom disabled to increase performance",
				},
			},
			RIM_LIGHTING = {
				TITLE = "Rim Lighting",
				ON = {
					NAME = "ON",
					DESC = "Silhouette-enhancing effects drawn around important characters <b>(Recommended)</b>",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Rim lighting disabled to increase performance",
				},
			},
			SHADOWS = {
				TITLE = "Shadows",
				ON = {
					NAME = "ON",
					DESC = "Shadows are drawn for props and characters <b>(Recommended)</b>",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Shadows disabled to increase performance",
				},
			},
			SCREEN_SHAKE = {
				TITLE = "Screen Shake",
				ON = {
					NAME = "ON",
					DESC = "Screen will shake when characters take {name.concept_damage}",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Screen will not shake when taking {name.concept_damage}",
				},
			},
			SCREEN_FLASH =
			{
				TITLE = "Screen Flash",
				ON = {
					NAME = "ON",
					DESC = "Screen will flash when characters take {name.concept_damage}",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Screen flashes are minimized",
				},
			},
		},
		AUDIO = {
			VOLUME = {
				MASTER =
				{
					NAME = "Master Volume",
					DESC = "Adjust overall volume of the game",
				},
				MUSIC = {
					NAME = "Music Volume",
					DESC = "Adjust the volume of music only",
				},
				SFX = {
					NAME = "SFX Volume",
					DESC = "Adjust the volume of sound effects only",
				},
				VOICE = {
					NAME = "Voice Volume",
					DESC = "Adjust the volume of character voices and narration only",
				},
				AMBIENCE = {
					NAME = "Ambience Volume",
					DESC = "Adjust the volume of ambient background sounds only (80% is default)",
				},
			},
			ENVIRONMENT_TITLE = "Listening Environment",
			ENVIRONMENT_NAME = {
				speakers = "Speakers",
				headphones = "Headphones",
				steamdeck = "Steam Deck",
			},
			ENVIRONMENT_DESC = {
				speakers = "Speakers. Sounds are panned more dramatically to account for sitting distance",
				headphones = "For wearing headphones. Panning is less dramatic to account for speaker separation",
				steamdeck = "Tuned for the built-in speakers on Valve's Steam Deck",
			},
			FORCE_MONO_MIX =
			{
				TITLE = "Force Mono Mix",
				ON =
				{
					NAME = "ON",
					DESC = "Output a monoaural audio mix",
				},
				OFF =
				{
					NAME = "OFF",
					DESC = "Output a stereo audio mix",
				},
			},
			OUTPUT_DEVICE =
			{
				NAME = "Output Device",
				DESC = "The device audio will play from",
			},
			MUTE_LOSE_FOCUS = {
				TITLE = "Mute on lose focus",
				ON = {
					NAME = "ON",
					DESC = "Silence the game when other windows have focus",
				},
				OFF = {
					NAME = "OFF",
					DESC = "Let the game make sound when other windows have focus",
				},
			},
		},
		OTHER = {
			LANGUAGE_TITLE = "Language",
			LANGUAGE_DESC = "The translation to use for the user interface and dialogue text.",

			DATACOLLECTION = {
				TITLE = "Data Collection",
				DESC = {
					ON =
					{
						NAME = "ON",
						DESC = "The game will send gameplay data to Klei's servers, to help us improve the game",
					},
					OFF =
					{
						NAME = "ON",
						DESC = "The game won't upload gameplay data to Klei's servers",
					},
				},
			},

			STREAMER_MODE =
			{
				TITLE = "Streamer Mode",
				TOOLTIP = "When enabled, the game will hide sensitive information such as ShareCodes.",
				ON =
				{
					NAME = "ON",
					DESC = "The game will hide sensitive information such as ShareCodes.",
				},
				OFF =
				{
					NAME = "OFF",
					DESC = "The game will show all information on screen.",
				},
			},

			SAVEDIR_TITLE = "Open Game Save Directory",
			SAVEDIR_DESC = "Click to open the folder containing your save files. Up one level from that folder is your log file",

			PROFILE_TITLE = "Capture a performance profile",
			PROFILE_DESC = "Click to capture a 30 second gameplay performance profile to send to us for further investigation.",
			PROFILE_BODY = "This will unpause the game and capture a 30 seconds performance profile to help us investigate performance issues.\n\nThe profiling can not be interrupted.\n\n<b>Warning - this file can be upwards of 50 MB</b>.",
			PROFILE_CONFIRM = "Proceed with performance profile?",
			PROFILE_YES = "Yes",
			PROFILE_NO = "Cancel",
 			PROFILE_DISABLED_TITLE = "Profiling Unavailable",
			PROFILE_DISABLED_BODY = "Performance captures are only available during gameplay.",

			RESET_SETTINGS_TITLE = "Reset Options",
			RESET_SETTINGS_DESC = "Click to reset user options to their default values. This will leave your progression and all unlocks intact",
			RESET_SETTINGS_CONFIRM = "Reset all configuration options?",
			RESET_SETTINGS_YES = "Reset",
			RESET_SETTINGS_NO = "Cancel",

			RESET_PROGRESS_TITLE = "Reset Gameplay Progress",
			RESET_PROGRESS_DESC = "Erase your save for all characters and start from the beginning. This will leave your settings intact",
			RESET_PROGRESS_CONFIRM = "Lose all gameplay progress?",
			RESET_PROGRESS_YES = "Delete Save",
			RESET_PROGRESS_NO = "Cancel",

			VIEW_CREDITS_TITLE = "View Credits",
			VIEW_CREDITS_DESC = "A list of cool folks who worked hard making this game.",

			VIEW_OPEN_SOURCE_CREDITS_TITLE = "Open Source Packages",
			VIEW_OPEN_SOURCE_CREDITS_DESC = "Thanks to these Open Source projects used in the creation of Rotwood.",
		},
	},

	GAMEPLAY_VIBRATION = "Vibration",
	GAMEPLAY_MOUSE_AIMING = "Mouse Aiming",

	AUDIO_SYSTEM_DEFAULT = "Use System Default",

	BIND_SECTIONS = {
		CONTROLS_BASIC = {
			gamepad = "Gamepad - Basic controls",
			keyboard = "Keyboard - Basic controls",
		},
		CONTROLS_COMBAT = {
			gamepad = "Gamepad - Combat actions",
			keyboard = "Keyboard - Combat actions",
		},
		ADMIN = "Troubleshooting",
	},

	KEYBINDING_SUBTITLE_KBM     = "Press the key to use for this input.\nOr <p bind='Controls.Digital.MENU_CANCEL_INPUT_BINDING' color=BTNICON_DARK> to cancel.",
	KEYBINDING_SUBTITLE_GAMEPAD = "Press the button to use for this input.\nOr <p bind='Controls.Digital.MENU_CANCEL_INPUT_BINDING' color=BTNICON_DARK> to cancel.",
	KEYBINDING_TEXT_KBM = "CURRENT KEY: %s",
	KEYBINDING_TEXT_GAMEPAD = "CURRENT BUTTON: %s",
	KEYBINDING_MISSING = "<p img='images/ui_ftf/warning.tex' color=0> Unmapped Control!",

	KEYBINDING_MOUSE_UNSUPPORTED = {
		TITLE = "Cannot Rebind Mouse",
		BODY = "Rebinding mouse inputs is not yet supported.",
	},
}

STRINGS.UI.DISKSPACE = 
{
	WARNING_TITLE = "Low Disk Space!",
	WARNING_DESC = "You are dangerously low on disk space. Please free up some space.\n\n<#RED>We may not be able to reliably save your progress.</>",
	CRITICAL_TITLE = "Not enough disk space!",
	TRY_AGAIN = "Try Again",
	CONTINUE = "Continue Anyway",
	CRITICAL_QUIT = "Quit",
	CRITICAL_DESC = "<#RED>You have run out of disk space!\nWe are not able to save your progress.\n\nPlease free up some space before continuing.</>",	
}

STRINGS.UI.FEEDBACK_SCREEN =
{
	TITLE = "SEND US YOUR FEEDBACK",
	ABOUT = "Notice something awful, strange, or wonderful? Tell us what happened and send us some diagnostic data so that we can look into the issue!",
	ABOUT_HOSTREQUEST = "OH NO!\n\nSomething's gone wrong and we're requesting feedback from all players in this session.", -- visually distinct from normal text!
	ABOUT_PERF_PROFILE = "This report helps identify framerate issues seen in the 30 second profiling period.\n\nDescribe what you saw and include as many checkboxes as possible.",

	SUBJECT_LABEL = "SUMMARY",
	MESSAGE_LABEL = "DETAILS",
	SUBJECT_PROMPT = "A short summary of your feedback",
	SUBMIT = "Submit",
	CANCEL = "Cancel",
	SEND_LOG = "Send Log",
	SEND_SCREENSHOT = "Send Screenshot",
	SEND_SAVE = "Send Latest Save",
	SEND_REPLAY = "Send Replay",
	SEND_STATS = "Send Runtime Statistics",
	SEND_PERFORMANCE_REPORT = "Send Performance Report",
	SEND_REPLAY_TT = "Check this if you want to include a replay of the last 5 seconds of gameplay!\n\nWill cause the report to take longer to submit.",
	TEMPLATE_PERF_PROFILE = "Performance problem: ",

	CATEGORIES =
	{
		AUDIO = "Audio",
		VISUAL = "Visual",
		WORDS = "Words",
		OTHER = "Gameplay/Other",
	},

	CATEGORY_PROMPT =
	{
		-- These must fit on a single line.
		FEEDBACK   = "What do you want to tell us about?",
		AUDIO = "Does something sound wrong? Or amazing?",
		VISUAL = "Tell us about what you saw.",
		WORDS = "Loved some dialogue? Found a typo? Confused?",
		OTHER = "What happened?",
	},

	BUG_ATTACHMENTS = "Be sure to write enough for us to understand or reproduce your issue.",

	REQUIRE_SUMMARY = "Briefly describe your issue in the Summary field!",

	SUBMITTING_TITLE = "Sending feedback",
	SUBMITTING_BODY = "Sending",

	SUBMITTED_TITLE = "Feedback submitted",
	SUBMITTED_BODY = "Thank you for your feedback. You are helping to make this game better!",
	SUBMITTED_TITLE_ERROR = "Failed to submit feedback",
	SUBMITTED_BODY_ERROR_TOO_LARGE = "The report was too large, try disabling the replay",
	SUBMITTED_BODY_ERROR_UNKNOWN = "There was an error submitting the report - please try again",
	SUBMITTED_OK = "OK",
}

STRINGS.UI.PRESSED_START_IN_SINGLE_PLAYER =
{
	-- More likely to press a gamepad than keyboard, so don't bother with "key".
	TITLE = "Button pressed on {device_icon}",
	SUBTITLE = "Want to add a new player on that device,\nor switch to it yourself?",
	BTN_ADD_PLAYER = "<p img='images/ui_ftf_icons/addplayer.tex' color=0 scale=1.2> Add local player",
	BTN_CHANGE_INPUT = "<p img='images/ui_ftf_icons/changecontroller.tex' color=0 scale=1.3> Switch to new device",
}

STRINGS.UI.NOTIFICATION =
{
	LOADING = "Loading",
	SAVING = "Saving",
	PRESS_TO_DISCONNECT = "Press {input} to Disconnect",
	CONNECTING = "Connecting",
}

STRINGS.UI.PAUSEMENU =
{
	HOST_PAUSE = "Host {player_name} paused the game",
	SUBTITLE_TOWN = "TOWN",
	SUBTITLE_DUNGEON = "LOCATION MAP",
	SUBTITLE_TRAVEL = "TRAVELLING...",
	SKIP_TRAVEL_BUTTON = "Skip  <p img='images/ui_ftf/arrow_ffwd.tex' scale=0.7 color=0>",
	BACK_BUTTON = "Back",
	CLOSE_BUTTON = "<p img='images/ui_ftf_dialog/convo_close.tex' color=0> Close",
	OPTIONS_BUTTON = "<p img='images/ui_ftf/ic_options.tex' color=0> Options",
	QUIT_BUTTON = "<p img='images/ui_ftf_dialog/convo_close.tex' color=0> Quit to menu",
	SAVEQUIT_BUTTON = "<p img='images/ui_ftf_dialog/convo_close.tex' color=0> Save and quit",
	ABANDON_BUTTON = "<p img='images/ui_ftf_dialog/convo_dismiss.tex' color=0> Abandon Run",
	MANAGE_MP_BUTTON = "<p img='images/ui_ftf_online/ic_playerlist.tex' color=0> Players  <p bind='Controls.Digital.SHOW_PLAYERS_LIST' scale=0.8 color=0>",

	IMSTUCK_BUTTON = "<p img='images/icons_ftf/inventory_key_items.tex' color=0> I'm Stuck!",
	IMSTUCK = {
		TITLE = "I'm Stuck!",
		BODY = "Sorry about that, Hunter! Our team is currently working hard to fix these issues.\n\nPlease <#RED>Write Feedback</> to send us diagnostics that help us to eliminate similar bugs in the future.\n\nTo unstick your character, select <#RED>Reload</> below to restart this room and try again.\n\nThank you. Your help and patience is appreciated!",
		SEND_FEEDBACK = "Write Feedback",
		RESTART_ROOM = "Reload",
		CANCEL = "Cancel",
		NON_HOST = "Ask the Host to press this if you are stuck",
	},

	NO_ABANDON_QUEST = "You can't leave right now!",
	NO_ABANDON_CLIENT = "Only the host can abandon.",

	SAVEANDQUITTITLE = "Save and return to main menu?",
	SAVEANDQUITBODY = "Don't worry. We'll wait here for you.",
	SAVEANDQUITYES = "I said quit!",
	SAVEANDQUITNO = "Never mind...",

	QUITTITLE = "Return to main menu?",
	QUITBODY = "Leaving so soon?",
	QUITYES = "I said quit!",
	QUITNO = "Never mind...",

	OPTIONS = "Settings",
	CONTROLS = "Controls",

	SAVEANDQUIT = "Save and Quit",
	QUIT = "Quit",
	CONTINUE = "Continue",
	DISCONNECT = "Disconnect",

	CLIENTQUITTITLE_DUNGEON = "Abandon Run?",
	CLIENTQUITSUBTITLE_DUNGEON = "Whistle for air rescue and head home?\nYou'll keep all loot collected this run.",
	CLIENTQUITTITLE_TOWN = "Quit",
	CLIENTQUITSUBTITLE_TOWN = "We'll save your progress.",
	CLIENTQUITBODY_MP = "You'll leave your friends behind.",
	CLIENTQUITBODY_MP_LOCAL = "You'll take your friends with you.",

	HOSTQUITTITLE = "Quit",
	HOSTQUITSUBTITLE = "Shut down server?",
	HOSTRETURNTOTOWN_TOOLTIP = "As Host, you'll automatically take your friends to town with you",
	HOSTQUIT_TOOLTIP = "As Host, quitting will disconnect the server and boot your friends",
	HOSTQUITBODY = "Are you sure you want to shut down the server? If you do, all current players will be disconnected.",

	RETURN_TO_TOWN_BUTTON = "<p img='images/ui_ftf_dialog/convo_dismiss.tex' color=0> Return to Town",
	CANCEL_QUIT = "Cancel",

	AFK = "Go AFK",
	SERVER_ADMIN = "Server Admin",
	ISSUE = "Report an Issue",
	JOINCODE_COPIED = "Copied to clipboard!",


	CONNECT_SIDEBAR = {
		TITLE = "Gamepad disconnected",
		INSTRUCTIONS = "Activate a device to use for {player_name}:",
		GAMEPAD_LIST = "Press {button_icon} on {device_icon} {device_name}",
		GAMEPAD_LIST_EMPTY = "No unused devices detected.",
		FOUND_AVAILABLE = "Assigning detected input on {device_icon}.",
		FOUND_IN_USE = "Detected input on {device_icon} assigned to another player.",
	},

}

STRINGS.UI.DATACOLLECTION = {
	-- Data Collection strings are standardized across Klei games.
	-- See #gdpr_compliance before changing.

	REQUIREMENT = "We require the collection of user data to provide online services. Players who disable data collection will only have access to play in offline mode.",

	EXPLAIN_POPUP = {
		OPT_OUT =
		{
			CONTINUE = "Disable",
		},

		OPT_IN =
		{
			CONTINUE = "Enable",
		},

		TITLE = "Data Collection",
		SEE_PRIVACY = "For more details on our privacy policy and how we use the data we collect, please see our official privacy policy.",
		BODY_RESTART = "<b>Changing this setting will require restarting the game.</>",

		PRIVACY_PORTAL = "View Privacy Policy",
		CANCEL = "Cancel",
	},

	QUIT_POPUP = {
		TITLE = "Quit to Apply Changes",
		CONFIRM = "Quit",
	},

	LOGIN = {
		TITLE = "Offline Mode",
		SEE_OPTIONS = "Data Collection settings can be modified in the Options menu.",
		CONTINUE = "Continue",
	},

	FEEDBACK_DISCLAIMER = "Report includes platform information for diagnostic purposes.",
}

STRINGS.UI.LEGACYLOOTPOPUP =
{
	TITLE 	= "Notice!",
	DESC 	= "We have streamlined the loot system so that you are more likely to get the loot that you are looking for.\n\nEach dungeon now has two loot types plus a boss loot. The loot this character has collected has been auto-converted to the new system.",
	CONFIRM	= "Got it!"
}

STRINGS.UI.CONTROLSCHEMEPOPUP =
{
	TITLE = "Select Control Scheme",
	DESC = "Your control scheme is an important part of the hunt. We suggest using Mouse Aiming for more accurate and fluid control, however practice may be required.\n\nDon't worry, you can always change this in the Options menu.",
	MOUSE_AIMING_ON = "Keep Mouse Aiming",
	MOUSE_AIMING_ON_TT = "<#RED>Recommended</>\nAttack in the direction of the mouse.\n\nThis allows greater use of directional combat in the game, making it easier to do combos.",
	MOUSE_AIMING_OFF = "<#RED>Disable</> Mouse Aiming",
	MOUSE_AIMING_OFF_TT = "Attack in the direction that you are facing.\n\nThis is sometimes more intuitive, but makes quickly switching targets and direction more difficult.",
}

STRINGS.UI.MANAGEMP =
{
	PLAYERS_IN_GAME = "Players In-Game",
	BLACK_LIST = "Blacklist",
	KICK = "Kick",
	REMOVE = "Remove",
}

STRINGS.UI.WORDPREDICTIONWIDET =
{
	DISMISS = "Dismiss",
}

STRINGS.UI.SCREENOPENER_PROP = {
	default = "Interact",
	-- These are prefab names. See ScreenOpener prop type in PropEditor.
	-- We automatically prefix with the interact button icon.
	gem_crafting_table = "Manage Gems",
	character_customizer_vshack = "Customize Character",
	armory = "Open Armoury",
	inventory_chest = "Open Chest",
}

STRINGS.UI.TOOLTIPS =
{
	LIGHT_ATTACK =
	{
		NAME = "Light Attack",
		DESC = "<p bind='Controls.Digital.ATTACK_LIGHT' color=BTNICON_DARK> <#RED>Light Attack</>.",
	},
	HEAVY_ATTACK =
	{
		NAME = "Heavy Attack",
		DESC = "<p bind='Controls.Digital.ATTACK_HEAVY' color=BTNICON_DARK> <#RED>Heavy Attack</>.",
	},
	SKILL =
	{
		NAME = "{name.concept_skill}",
		DESC = "<p bind='Controls.Digital.SKILL' color=BTNICON_DARK> <#RED>{name.concept_skill}</>.",
	},
	HIT_STREAK =
	{
		NAME = "Hit Streak",
		DESC = "Consistently deal <#RED>{name.concept_damage}</> to enemies without stopping or being hit.",
	},
	FOCUS_HIT =
	{
		NAME = "<#BLUE>{name.concept_focus_hit}</>",
		DESC = "Bonus {name.concept_damage} from using the weapon efficiently. {name.concept_damage} turns <#BLUE>Blue</>.",
	},
	CRITICAL_HIT =
	{
		NAME = "Critical Hit",
		DESC = "Deals double <#RED>{name.concept_damage}</>.",
	},
	CRIT_CHANCE =
	{
		NAME = "Critical Chance",
		DESC = "Odds of getting a <#RED>Critical Hit</> any time you deal <#RED>{name.concept_damage}</>.",
	},
	CRIT_DAMAGE =
	{
		NAME = "Critical {name.concept_damage}",
		DESC = "Bonus <#RED>{name.concept_damage}</> dealt when getting a <#RED>Critical Hit</>.",
	},
	KNOCKED_DOWN =
	{
		NAME = "Knocked Down",
		DESC = "An enemy that's been knocked over.",
	},
	CHARGE =
	{
		NAME = "Charge",
		DESC = "On <#RED>Death</>, start a <#RED>Chain Reaction</>.",
	},
	SEEDED =
	{
		NAME = "",
		DESC = "<#RED>Seeded</>\n\n[TEMP]It does something, I swear!", --TODO #seed
	},
	CHAIN_REACTION =
	{
		NAME = "Chain Reaction",
		DESC = "Deal <#RED>{name.concept_damage}</> to all <#RED>Charged</> enemies and consume <#RED>1 Charge</>.",
	},
	SHIELD =
	{
		NAME = "Shield",
		DESC = "When you take <#RED>{name.concept_damage}</>, your <#RED>Shield</> breaks and you take <#RED>1 {name.concept_damage}</> instead.",
	},
	SHIELD_SEGMENTS =
	{
		NAME = "Shield Segment",
		DESC = "Collect <#RED>4 Shield Segments</> to gain <#RED>Shield</>.",
	},
	IFRAME_DODGE =
	{
		NAME = "Perfect Dodge",
		DESC = "Narrowly <#RED>Dodge</> an attack at the last second, leaving a cloud of dust.",
	},
	QUICK_RISE =
	{
		NAME = "Quick Rise",
		DESC = "When getting knocked down, tap <#RED>Dodge</> as you hit the ground.",
	},
	KONJUR =
	{
		NAME = "{name.i_konjur}",
		DESC = "Precious currency in Rotwood, used to pay for things like refilling <#RED>Potions</> or upgrading <#RED>{name_multiple.concept_relic}</>.",
	},
	LUCKY =
	{
		NAME = "Lucky Roll!",
		DESC = "The quality of this roll was upgraded because of your <#RED>Luck</>! Lucky you!",
	},
	MATERIALS =
	{
		NAME = "Materials",
		DESC = "Items used for conducting <#RED>Monster Research</> and crafting <#RED>Weapons</>, <#RED>Armour</>, and more."
	},
}

-- Use for displaying text during cinematics.
STRINGS.CINEMATICS =
{

}

-- TODO #weight - fix up these strings as you will
STRINGS.UI.WEIGHT_CHANGED_SCREEN =
{
	TITLE = "Weight Class Changed",
	SUB_TITLE_FMT = "Your Weight Class is now <#RED>{weight_class}</>!",
	LIGHT = {
		BRIEF = "{name.light_weight}",
		VERBOSE = "<#RED>{name.light_weight} Class</> builds will <#RED>{name.concept_dodge}</> further and have a higher <#RED>{name.concept_runspeed}."
	},
	-- User is not interested in the first time they return to medium weight class.
	-- MEDIUM = {
	-- 	BRIEF = "",
	-- 	VERBOSE = ""
	-- },
	HEAVY = {
		BRIEF = "{name.heavy_weight}",
		VERBOSE = "<#RED>{name.heavy_weight} Class</> builds will take less <#RED>{name.concept_damage}</> and mitigate adverse movement effects."
	},
	OK = "OK"
}

STRINGS.UI.TUTORIAL_POPUPS =
{
	DRINK_POTION = "Hold <p bind='Controls.Digital.USE_POTION' color=0> to Drink Potion!",
	CANNON_RELOAD = "Press <p bind='Controls.Digital.DODGE' color=0> twice to Reload!",
}

STRINGS.UI.MOUSE_AIMING_POPUP =
{
	TITLE = "Mouse Aiming",
	BODY = "In Rotwood, your character will always face your mouse cursor. Use your <#RED>Mouse</> to aim your attacks.\n\nWe recommend playing this way because you'll have an easier time doing more complicated combos later, but if you would prefer to aim your attacks with your <#RED>Keyboard</>, please say so below!.\n\nYou can always change your mind in the <#RED>Options Screen</>.",

	ENABLE_MOUSE_AIMING = "Mouse Aiming (Recommended)",
	DISABLE_MOUSE_AIMING = "No Mouse Aiming",
}
